/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.upload.receivers;

import com.vaadin.flow.component.upload.receivers.FileFactory;
import com.vaadin.flow.component.upload.receivers.UploadOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFileBuffer
implements Serializable {
    private FileFactory factory;

    public AbstractFileBuffer() {
        this.factory = fileName -> {
            String tempFileName = "upload_tmpfile_" + fileName + "_" + System.currentTimeMillis();
            return File.createTempFile(tempFileName, null);
        };
    }

    public AbstractFileBuffer(FileFactory factory) {
        this.factory = factory;
    }

    protected FileOutputStream createFileOutputStream(String fileName) {
        try {
            return new UploadOutputStream(this.factory.createFile(fileName));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to create file output stream for: '" + fileName + "'", e);
            return null;
        }
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }
}

