/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker.testbench;

import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasSelectByText;
import com.vaadin.testbench.HasStringValueProperty;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

@Element(value="vaadin-time-picker")
public class TimePickerElement
extends TestBenchElement
implements HasStringValueProperty,
HasSelectByText,
HasHelper {
    public TimePickerComboBoxElement getTimePickerComboBox() {
        return (TimePickerComboBoxElement)this.$(TimePickerComboBoxElement.class).first();
    }

    public TestBenchElement getTimePickerInputElement() {
        return this.$("input").first();
    }

    public String getText() {
        return this.getPropertyString(new String[]{"textContent"});
    }

    public String getItemText(int index) {
        return ((TimePickerOverlayElement)this.$(TimePickerOverlayElement.class).onPage().first()).getItem(index).getText();
    }

    public String getLastItemText() {
        return ((TimePickerOverlayElement)this.$(TimePickerOverlayElement.class).onPage().first()).getLastItem().getText();
    }

    public String getTimePickerInputValue() {
        return this.getTimePickerInputElement().getPropertyString(new String[]{"value"});
    }

    public void openDropDown() {
        this.executeScript("arguments[0].open()", new Object[]{this.getTimePickerComboBox()});
        this.waitUntilDropDownOpen();
    }

    public void waitUntilDropDownOpen() {
        this.$(TimePickerOverlayElement.class).onPage().waitForFirst();
    }

    public void closeDropDown() {
        this.executeScript("const cb = arguments[0]; window.requestAnimationFrame(function(){ cb.close(); });", new Object[]{this.getTimePickerComboBox()});
        this.waitUntil(input -> input.findElements(By.tagName((String)"vaadin-time-picker-overlay")).isEmpty());
    }

    public void scrollToItem(int index) {
        this.executeScript("arguments[0].$.dropdown._scroller.scrollIntoView(arguments[1])", new Object[]{this.getTimePickerComboBox(), index});
    }

    public void selectItemByIndex(int index) {
        this.openDropDown();
        this.scrollToItem(index);
        TestBenchElement item = ((TimePickerOverlayElement)this.$(TimePickerOverlayElement.class).onPage().first()).getItem(index);
        item.click();
    }

    public void selectByText(String timeInput) {
        Objects.requireNonNull(timeInput, "null input not accepted");
        TestBenchElement timePickerInputElement = this.getTimePickerInputElement();
        this.executeScript("arguments[0].value = ''", new Object[]{timePickerInputElement});
        timePickerInputElement.sendKeys(new CharSequence[]{timeInput + Keys.RETURN});
    }

    public String getSelectedText() {
        return this.getTimePickerInputElement().getPropertyString(new String[]{"value"});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    @Element(value="vaadin-time-picker-overlay")
    public static class TimePickerOverlayElement
    extends TestBenchElement {
        public TestBenchElement getItem(int index) {
            return this.$("vaadin-time-picker-item").all().stream().filter(item -> index == item.getPropertyInteger(new String[]{"index"})).findFirst().get();
        }

        public TestBenchElement getLastItem() {
            return (TestBenchElement)this.$("vaadin-time-picker-item").all().stream().max((a, b) -> a.getPropertyInteger(new String[]{"index"}) - b.getPropertyInteger(new String[]{"index"})).get();
        }
    }

    @Element(value="vaadin-time-picker-combo-box")
    public static class TimePickerComboBoxElement
    extends TestBenchElement {
    }
}

