/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.timepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.timepicker.GeneratedVaadinTimePicker;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

@JavaScript(value="frontend://timepickerConnector.js")
public class TimePicker
extends GeneratedVaadinTimePicker<TimePicker, LocalTime>
implements HasSize,
HasValidation,
HasEnabled {
    private static final SerializableFunction<String, LocalTime> PARSER = (SerializableFunction & Serializable)valueFromClient -> valueFromClient == null || valueFromClient.isEmpty() ? null : LocalTime.parse(valueFromClient);
    private static final SerializableFunction<LocalTime, String> FORMATTER = (SerializableFunction & Serializable)valueFromModel -> valueFromModel == null ? "" : valueFromModel.toString();
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private static final long MILLISECONDS_IN_AN_HOUR = 3600000L;
    private Locale locale;

    public TimePicker() {
        this((LocalTime)null);
    }

    public TimePicker(LocalTime time) {
        super(time, null, String.class, PARSER, FORMATTER);
    }

    public TimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public TimePicker(String label, LocalTime time) {
        this(time);
        this.setLabel(label);
    }

    public TimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<TimePicker, LocalTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        long stepAsMilliseconds = step.getSeconds() * 1000L + (long)((double)step.getNano() / 1000000.0);
        if (step.isNegative() || stepAsMilliseconds == 0L) {
            throw new IllegalArgumentException("Step cannot be negative and must be larger than 0 milliseconds");
        }
        if (86400000L % stepAsMilliseconds != 0L && 3600000L % stepAsMilliseconds != 0L) {
            throw new IllegalArgumentException("Given step " + step.toString() + " does not divide evenly a day or an hour.");
        }
        super.setStep((double)step.getSeconds() + (double)step.getNano() / 1.0E9);
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return Duration.ofHours(1L);
        }
        return Duration.ofNanos((long)(this.getStepDouble() * 1.0E9));
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<GeneratedVaadinTimePicker.InvalidChangeEvent<TimePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getLocale() == null) {
            this.setLocale(attachEvent.getUI().getLocale());
        }
        this.initConnector();
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("window.Vaadin.Flow.timepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        if (locale.getLanguage().isEmpty()) {
            throw new UnsupportedOperationException("Given Locale " + locale.getDisplayName() + " is not supported by time picker because it is missing the language information.");
        }
        this.locale = locale;
        StringBuilder bcp47LanguageTag = new StringBuilder(locale.getLanguage());
        if (!locale.getCountry().isEmpty()) {
            bcp47LanguageTag.append("-").append(locale.getCountry());
        }
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().callFunction("$connector.setLocale", new Serializable[]{bcp47LanguageTag.toString()}));
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public static Stream<Locale> getSupportedAvailableLocales() {
        return Stream.of(Locale.getAvailableLocales()).filter(locale -> !locale.getLanguage().isEmpty());
    }
}

