/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.textfield.TextAreaVariant;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Tag(value="vaadin-text-area")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.6.1"), @NpmPackage(value="@vaadin/text-area", version="24.6.1")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/text-area/src/vaadin-text-area.js")})
public class TextArea
extends TextFieldBase<TextArea, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextAreaVariant> {
    private TextAreaI18n i18n;
    private Validator<String> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(TextAreaI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)this.getEmptyValue())).isError()) {
            return requiredResult;
        }
        ValidationResult maxLengthResult = ValidationUtil.validateMaxLengthConstraint((String)this.getI18nErrorMessage(TextAreaI18n::getMaxLengthErrorMessage), (String)value, this.hasMaxLength() ? Integer.valueOf(this.getMaxLength()) : null);
        if (maxLengthResult.isError()) {
            return maxLengthResult;
        }
        ValidationResult minLengthResult = ValidationUtil.validateMinLengthConstraint((String)this.getI18nErrorMessage(TextAreaI18n::getMinLengthErrorMessage), (String)value, (Integer)this.getMinLength());
        if (minLengthResult.isError()) {
            return minLengthResult;
        }
        ValidationResult patternResult = ValidationUtil.validatePatternConstraint((String)this.getI18nErrorMessage(TextAreaI18n::getPatternErrorMessage), (String)value, (String)this.getPattern());
        if (patternResult.isError()) {
            return patternResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<TextArea, String> validationController = new ValidationController((Component)this);

    public TextArea() {
        this(true);
    }

    private TextArea(boolean isInitialValueOptional) {
        super("", "", false, isInitialValueOptional);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public TextArea(String label) {
        this();
        this.setLabel(label);
    }

    public TextArea(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextArea(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextArea(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    public void scrollToStart() {
        this.getElement().callJsFunction("scrollToStart", new Serializable[0]);
    }

    public void scrollToEnd() {
        this.getElement().callJsFunction("scrollToEnd", new Serializable[0]);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    @Override
    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    private boolean hasMaxLength() {
        return this.getElement().getProperty("maxlength") != null;
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public int getMinRows() {
        return this.getElement().getProperty("minRows", 2);
    }

    public void setMinRows(int minRows) {
        this.getElement().setProperty("minRows", (double)minRows);
    }

    public Integer getMaxRows() {
        String maxRows = this.getElement().getProperty("maxRows");
        if (maxRows != null && !maxRows.isEmpty()) {
            return Integer.parseInt(maxRows);
        }
        return null;
    }

    public void setMaxRows(Integer maxRows) {
        if (maxRows != null) {
            this.getElement().setProperty("maxRows", (double)maxRows.intValue());
        } else {
            this.getElement().removeProperty("maxRows");
        }
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public Validator<String> getDefaultValidator() {
        return this.defaultValidator;
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)this.getValue());
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }

    public TextAreaI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(TextAreaI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
    }

    private String getI18nErrorMessage(Function<TextAreaI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class TextAreaI18n
    implements Serializable {
        private String requiredErrorMessage;
        private String minLengthErrorMessage;
        private String maxLengthErrorMessage;
        private String patternErrorMessage;

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public TextAreaI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinLengthErrorMessage() {
            return this.minLengthErrorMessage;
        }

        public TextAreaI18n setMinLengthErrorMessage(String errorMessage) {
            this.minLengthErrorMessage = errorMessage;
            return this;
        }

        public String getMaxLengthErrorMessage() {
            return this.maxLengthErrorMessage;
        }

        public TextAreaI18n setMaxLengthErrorMessage(String errorMessage) {
            this.maxLengthErrorMessage = errorMessage;
            return this;
        }

        public String getPatternErrorMessage() {
            return this.patternErrorMessage;
        }

        public TextAreaI18n setPatternErrorMessage(String errorMessage) {
            this.patternErrorMessage = errorMessage;
            return this;
        }
    }
}

