/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.AbstractNumberField;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.function.SerializableFunction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;

@Tag(value="vaadin-number-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.5"), @NpmPackage(value="@vaadin/number-field", version="24.2.5")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/number-field/src/vaadin-number-field.js")})
public class NumberField
extends AbstractNumberField<NumberField, Double>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    public NumberField() {
        this(new Formatter());
    }

    public NumberField(String label) {
        this();
        this.setLabel(label);
    }

    public NumberField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public NumberField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public NumberField(String label, Double initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<NumberField, Double>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private NumberField(Formatter formatter) {
        super(formatter::parse, formatter, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public void setMin(double min) {
        super.setMin(min);
    }

    public double getMin() {
        return this.getMinDouble();
    }

    @Override
    public void setMax(double max) {
        super.setMax(max);
    }

    public double getMax() {
        return this.getMaxDouble();
    }

    @Override
    public void setStep(double step) {
        if (step <= 0.0) {
            throw new IllegalArgumentException("The step cannot be less or equal to zero.");
        }
        super.setStep(step);
    }

    public double getStep() {
        return this.getStepDouble();
    }

    private static class Formatter
    implements SerializableFunction<Double, String> {
        private final DecimalFormat decimalFormat = new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

        private Formatter() {
            this.decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
        }

        public String apply(Double valueFromModel) {
            return valueFromModel == null ? "" : this.decimalFormat.format(valueFromModel);
        }

        private Double parse(String valueFromClient) {
            try {
                return valueFromClient == null || valueFromClient.isEmpty() ? null : Double.valueOf(this.decimalFormat.parse(valueFromClient).doubleValue());
            }
            catch (ParseException e) {
                throw new NumberFormatException(valueFromClient);
            }
        }
    }
}

