/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.TextAreaVariant;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-text-area")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.7"), @NpmPackage(value="@vaadin/text-area", version="24.1.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/text-area/src/vaadin-text-area.js")})
public class TextArea
extends TextFieldBase<TextArea, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextAreaVariant> {
    private boolean isConnectorAttached;
    private TextFieldValidationSupport validationSupport;

    public TextArea() {
        this(true);
    }

    private TextArea(boolean isInitialValueOptional) {
        super("", "", false, isInitialValueOptional);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
    }

    public TextArea(String label) {
        this();
        this.setLabel(label);
    }

    public TextArea(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextArea(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextArea(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private TextFieldValidationSupport getValidationSupport() {
        if (this.validationSupport == null) {
            this.validationSupport = new TextFieldValidationSupport((HasValue<?, String>)this);
        }
        return this.validationSupport;
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
        this.getValidationSupport().setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
        this.getValidationSupport().setMinLength(minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.getValidationSupport().setRequired(required);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
        this.getValidationSupport().setPattern(pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getValidationSupport().setRequired(requiredIndicatorVisible);
    }

    public Validator<String> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.getValidationSupport().checkValidity((String)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<String> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
    }

    protected void validate() {
        this.setInvalid(this.getValidationSupport().isInvalid(this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }
}

