/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-email-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.0.2"), @NpmPackage(value="@vaadin/email-field", version="24.0.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/email-field/src/vaadin-email-field.js")})
public class EmailField
extends TextFieldBase<EmailField, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    private static final String EMAIL_PATTERN = "^([a-zA-Z0-9_\\.\\-+])+@[a-zA-Z0-9-.]+\\.[a-zA-Z0-9-]{2,}$";
    private boolean isConnectorAttached;
    private TextFieldValidationSupport validationSupport;

    public EmailField() {
        super("", "", false, true);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
    }

    public EmailField(String label) {
        this();
        this.setLabel(label);
    }

    public EmailField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public EmailField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public EmailField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public EmailField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<EmailField, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private TextFieldValidationSupport getValidationSupport() {
        if (this.validationSupport == null) {
            this.validationSupport = new TextFieldValidationSupport((HasValue<?, String>)this);
            this.validationSupport.setPattern(EMAIL_PATTERN);
        }
        return this.validationSupport;
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
        this.getValidationSupport().setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
        this.getValidationSupport().setMinLength(minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.getValidationSupport().setRequired(required);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
        this.getValidationSupport().setPattern(pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getValidationSupport().setRequired(requiredIndicatorVisible);
    }

    public Validator<String> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.getValidationSupport().checkValidity((String)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<String> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
    }

    protected void validate() {
        this.setInvalid(this.getValidationSupport().isInvalid(this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }
}

