/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.CompositionNotifier;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.InputNotifier;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.textfield.FieldValidationUtil;
import com.vaadin.flow.component.textfield.GeneratedVaadinTextArea;
import com.vaadin.flow.component.textfield.HasAutocapitalize;
import com.vaadin.flow.component.textfield.HasAutocomplete;
import com.vaadin.flow.component.textfield.HasAutocorrect;
import com.vaadin.flow.component.textfield.HasPrefixAndSuffix;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.io.Serializable;

public class TextArea
extends GeneratedVaadinTextArea<TextArea, String>
implements HasSize,
HasValidation,
HasValueChangeMode,
HasPrefixAndSuffix,
InputNotifier,
KeyNotifier,
CompositionNotifier,
HasAutocomplete,
HasAutocapitalize,
HasAutocorrect,
HasHelper {
    private ValueChangeMode currentMode;
    private boolean isConnectorAttached;
    private int valueChangeTimeout = 400;
    private TextFieldValidationSupport validationSupport;

    public TextArea() {
        super("", "", false);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
    }

    public TextArea(String label) {
        this();
        this.setLabel(label);
    }

    public TextArea(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextArea(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextArea(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextArea(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextArea, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private TextFieldValidationSupport getValidationSupport() {
        if (this.validationSupport == null) {
            this.validationSupport = new TextFieldValidationSupport((HasValue<?, String>)this);
        }
        return this.validationSupport;
    }

    public ValueChangeMode getValueChangeMode() {
        return this.currentMode;
    }

    public void setValueChangeMode(ValueChangeMode valueChangeMode) {
        this.currentMode = valueChangeMode;
        this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        this.applyChangeTimeout();
    }

    public void setValueChangeTimeout(int valueChangeTimeout) {
        this.valueChangeTimeout = valueChangeTimeout;
        this.applyChangeTimeout();
    }

    public int getValueChangeTimeout() {
        return this.valueChangeTimeout;
    }

    private void applyChangeTimeout() {
        ValueChangeMode.applyChangeTimeout((ValueChangeMode)this.getValueChangeMode(), (int)this.getValueChangeTimeout(), (DomListenerRegistration)this.getSynchronizationRegistration());
    }

    public String getErrorMessage() {
        return super.getErrorMessageString();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    public boolean isAutoselect() {
        return super.isAutoselectBoolean();
    }

    @Override
    public void setAutoselect(boolean autoselect) {
        super.setAutoselect(autoselect);
    }

    public boolean isClearButtonVisible() {
        return this.isClearButtonVisibleBoolean();
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        super.setAutofocus(autofocus);
    }

    public boolean isAutofocus() {
        return this.isAutofocusBoolean();
    }

    public void setMaxLength(int maxLength) {
        super.setMaxlength(maxLength);
        this.getValidationSupport().setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getMaxlengthDouble();
    }

    public void setMinLength(int minLength) {
        super.setMinlength(minLength);
        this.getValidationSupport().setMinLength(minLength);
    }

    public int getMinLength() {
        return (int)this.getMinlengthDouble();
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.getValidationSupport().setRequired(required);
    }

    public boolean isPreventInvalidInput() {
        return this.isPreventInvalidInputBoolean();
    }

    @Override
    public void setPreventInvalidInput(boolean preventInvalidInput) {
        super.setPreventInvalidInput(preventInvalidInput);
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getValidationSupport().setRequired(requiredIndicatorVisible);
    }

    @Override
    protected void validate() {
        this.setInvalid(this.getValidationSupport().isInvalid(this.getValue()));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        FieldValidationUtil.disableClientValidation((Component)this);
    }
}

