/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel.setup;

import com.vaadin.testbench.Parameters;
import com.vaadin.testbench.TestBench;
import java.net.URL;
import java.time.Duration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDriver {
    private static final int BROWSER_INIT_ATTEMPTS = 5;

    public WebDriver createDriver(String hubURL, DesiredCapabilities capabilities) throws Exception {
        for (int i = 1; i <= 5; ++i) {
            try {
                ClientConfig config = ClientConfig.defaultConfig().readTimeout(Duration.ofSeconds(Parameters.getReadTimeout())).baseUrl(new URL(hubURL));
                HttpCommandExecutor executor = new HttpCommandExecutor(config);
                RemoteWebDriver driver = new RemoteWebDriver((CommandExecutor)executor, (Capabilities)capabilities);
                return TestBench.createDriver((WebDriver)driver);
            }
            catch (Exception e) {
                this.getLogger().error("Browser startup for " + capabilities + " failed on attempt " + i, (Throwable)e);
                if (i != 5) continue;
                throw e;
            }
        }
        return null;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

