/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elements.GridElement;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebElement;

public class TreeGridElement
extends GridElement {
    public void expandWithClick(int rowIndex) {
        this.expandWithClick(rowIndex, 0);
    }

    public void expandWithClick(int rowIndex, int hierarchyColumnIndex) {
        if (this.isRowExpanded(rowIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowIndex + " was expanded already");
        }
        this.getExpandElement(rowIndex, hierarchyColumnIndex).click();
    }

    public void collapseWithClick(int rowIndex) {
        this.collapseWithClick(rowIndex, 0);
    }

    public void collapseWithClick(int rowIndex, int hierarchyColumnIndex) {
        if (this.isRowCollapsed(rowIndex, hierarchyColumnIndex)) {
            throw new IllegalStateException("The element at row " + rowIndex + " was collapsed already");
        }
        this.getExpandElement(rowIndex, hierarchyColumnIndex).click();
    }

    public boolean isRowExpanded(int rowIndex, int hierarchyColumnIndex) {
        WebElement expandElement = this.getExpandElement(rowIndex, hierarchyColumnIndex);
        List<String> classes = Arrays.asList(expandElement.getAttribute("class").split(" "));
        return classes.contains("expanded") && !classes.contains("collapsed");
    }

    public boolean isRowCollapsed(int rowIndex, int hierarchyColumnIndex) {
        return !this.isRowExpanded(rowIndex, hierarchyColumnIndex);
    }

    public boolean hasExpandToggle(int rowIndex, int hierarchyColumnIndex) {
        WebElement expandElement = this.getExpandElement(rowIndex, hierarchyColumnIndex);
        List<String> classes = Arrays.asList(expandElement.getAttribute("class").split(" "));
        return classes.contains("expanded") || classes.contains("collapsed");
    }

    public WebElement getExpandElement(int rowIndex, int hierarchyColumnIndex) {
        return this.getCell(rowIndex, hierarchyColumnIndex).findElement(By.className((String)"v-treegrid-expander"));
    }
}

