/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.List;
import java.util.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@ServerClass(value="com.vaadin.ui.MenuBar")
public class MenuBarElement
extends AbstractComponentElement {
    private Point lastItemLocationMovedTo = null;

    private void clickItem(String item) {
        WebElement webElement = this.getVisibleItem("#" + item);
        if (webElement == null) {
            throw new NoSuchElementException("Menu item " + item + " is not available.");
        }
        this.activateOrOpenSubmenu(webElement, true);
    }

    public void clickItem(String ... path) {
        if (path.length > 1) {
            this.closeAll();
        }
        for (String itemName : path) {
            this.clickItem(itemName);
        }
    }

    private void closeAll() {
        this.lastItemLocationMovedTo = null;
        WebElement selectedItem = this.getSelectedTopLevelItem();
        if (selectedItem != null) {
            this.activateOrOpenSubmenu(selectedItem, true);
        }
    }

    private WebElement getSelectedTopLevelItem() {
        List selectedItems = this.findElements(org.openqa.selenium.By.className((String)"v-menubar-menuitem-selected"));
        if (selectedItems.isEmpty()) {
            return null;
        }
        return (WebElement)selectedItems.get(0);
    }

    private WebElement getVisibleItem(String item) {
        return this.findElement(By.vaadin((String)item));
    }

    private void activateOrOpenSubmenu(WebElement item, boolean alwaysClick) {
        if (this.lastItemLocationMovedTo == null || !this.isAnySubmenuVisible()) {
            item.click();
            if (this.hasSubmenu(item)) {
                this.lastItemLocationMovedTo = item.getLocation();
            }
            return;
        }
        Actions action = new Actions(this.getDriver());
        action.moveToElement(item);
        action.build().perform();
        this.lastItemLocationMovedTo = this.isLeaf(item) || this.isSelectedTopLevelItem(item) ? null : item.getLocation();
        if (alwaysClick || this.isLeaf(item) || !this.isAnySubmenuVisible()) {
            action = new Actions(this.getDriver());
            action.click();
            action.build().perform();
        }
    }

    private boolean isSelectedTopLevelItem(WebElement item) {
        WebElement selectedItem = this.getSelectedTopLevelItem();
        if (selectedItem == null) {
            return false;
        }
        String itemCaption = ((WebElement)item.findElements(org.openqa.selenium.By.className((String)"v-menubar-menuitem-caption")).get(0)).getAttribute("innerHTML");
        String selectedItemCaption = ((WebElement)selectedItem.findElements(org.openqa.selenium.By.className((String)"v-menubar-menuitem-caption")).get(0)).getAttribute("innerHTML");
        return itemCaption.equals(selectedItemCaption);
    }

    private boolean isAnySubmenuVisible() {
        WebElement selectedItem = this.getSelectedTopLevelItem();
        if (selectedItem == null) {
            return false;
        }
        return this.hasSubmenu(selectedItem);
    }

    private boolean hasSubmenu(WebElement item) {
        List submenuIndicatorElements = item.findElements(org.openqa.selenium.By.className((String)"v-menubar-submenu-indicator"));
        return submenuIndicatorElements.size() != 0;
    }

    private boolean isLeaf(WebElement item) {
        return !this.hasSubmenu(item);
    }
}

