/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.tabs.GeneratedVaadinTab;

public class Tab
extends GeneratedVaadinTab<Tab>
implements HasComponents {
    private static final String FLEX_GROW_CSS_PROPERTY = "flexGrow";

    public Tab() {
    }

    public Tab(String label) {
        this.setLabel(label);
    }

    public Tab(Component ... components) {
        this.add(components);
    }

    public final String getLabel() {
        return this.getElement().getText();
    }

    public final void setLabel(String label) {
        this.getElement().setText(label);
    }

    public void setFlexGrow(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property cannot be negative");
        }
        if (flexGrow == 0.0) {
            this.getElement().getStyle().remove(FLEX_GROW_CSS_PROPERTY);
        } else {
            this.getElement().getStyle().set(FLEX_GROW_CSS_PROPERTY, String.valueOf(flexGrow));
        }
    }

    public double getFlexGrow() {
        String ratio = this.getElement().getStyle().get(FLEX_GROW_CSS_PROPERTY);
        if (ratio == null || ratio.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(ratio);
        }
        catch (Exception e) {
            throw new IllegalStateException("The flex grow property of the component is not parseable to double: " + ratio, e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.setDisabled(!enabled);
    }

    public boolean isEnabled() {
        return !this.isDisabledBoolean();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
    }

    public boolean isSelected() {
        return super.isSelectedBoolean();
    }

    public String toString() {
        return "Tab{" + this.getLabel() + "}";
    }
}

