/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.AppShellSettings;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.spring.security.RequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatchers;

public class WebIconsRequestMatcher
implements RequestMatcher {
    private final RequestMatcher matcher;

    public WebIconsRequestMatcher(VaadinService service, String urlMapping) {
        this.matcher = WebIconsRequestMatcher.initMatchers(service, urlMapping);
    }

    public boolean matches(HttpServletRequest request) {
        return this.matcher.matches(request);
    }

    private static RequestMatcher initMatchers(VaadinService service, String urlMapping) {
        AppShellRegistry appShellRegistry = AppShellRegistry.getInstance((VaadinContext)service.getContext());
        Class appShellClass = appShellRegistry.getShell();
        UnaryOperator urlMapper = path -> RequestUtil.applyUrlMapping(urlMapping, path);
        HashSet<String> paths = new HashSet<String>();
        WebIconsRequestMatcher.appendFavIconPath(paths, appShellClass, service, urlMapper);
        WebIconsRequestMatcher.appendPwaIconPaths(paths, appShellClass, service, urlMapper);
        return RequestMatchers.anyOf((RequestMatcher[])RequestUtil.antMatchers((String[])paths.toArray(String[]::new)));
    }

    private static void appendFavIconPath(final Set<String> paths, Class<? extends AppShellConfigurator> appShellClass, VaadinService vaadinService, final UnaryOperator<String> urlMapper) {
        if (appShellClass != null) {
            AppShellSettings settings = new AppShellSettings(){

                public void addFavIcon(String rel, String href, String sizes) {
                    this.registerPath(href);
                }

                public void addFavIcon(Inline.Position position, String rel, String href, String sizes) {
                    this.registerPath(href);
                }

                private void registerPath(String path) {
                    if (!path.startsWith("/")) {
                        path = (String)urlMapper.apply(path);
                    }
                    paths.add(path);
                }
            };
            try {
                ((AppShellConfigurator)vaadinService.getInstantiator().getOrCreate(appShellClass)).configurePage(settings);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(WebIconsRequestMatcher.class).debug("Cannot detect favicon path", (Throwable)ex);
            }
        }
        paths.remove("/favicon.ico");
    }

    private static void appendPwaIconPaths(Set<String> paths, Class<?> appShellClass, VaadinService vaadinService, UnaryOperator<String> urlMapper) {
        PWA pwa;
        Class pwaAnnotatedClass = appShellClass;
        if (pwaAnnotatedClass == null) {
            pwaAnnotatedClass = ApplicationRouteRegistry.getInstance((VaadinContext)vaadinService.getContext()).getPwaConfigurationClass();
        }
        PWA pWA = pwa = pwaAnnotatedClass != null ? pwaAnnotatedClass.getAnnotation(PWA.class) : null;
        if (pwa != null && !"icons/icon.png".equals(pwa.iconPath())) {
            String baseIconPrefix = pwa.iconPath().startsWith("/") ? "" : "/";
            paths.add(baseIconPrefix + pwa.iconPath());
            HandlerHelper.getIconVariants((String)pwa.iconPath()).stream().map(urlMapper).collect(Collectors.toCollection(() -> paths));
        }
    }
}

