/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.UidlRedirectStrategy;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategyConfiguration;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.stateless.VaadinStatelessSecurityConfigurer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfException;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.WebApplicationContext;

@Import(value={VaadinAwareSecurityContextHolderStrategyConfiguration.class})
public abstract class VaadinWebSecurity {
    @Autowired
    private VaadinDefaultRequestCache vaadinDefaultRequestCache;
    @Autowired
    private RequestUtil requestUtil;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ViewAccessChecker viewAccessChecker;
    @Value(value="#{servletContext.contextPath}")
    private String servletContextPath;
    private final AuthenticationContext authenticationContext = new AuthenticationContext();
    private LogoutConfigurer<HttpSecurity> logoutConfigurer;

    @Bean(name={"VaadinSecurityFilterChainBean"})
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        this.configure(http);
        this.logoutConfigurer = http.logout();
        this.logoutConfigurer.invalidateHttpSession(true);
        this.addLogoutHandlers(arg_0 -> this.logoutConfigurer.addLogoutHandler(arg_0));
        DefaultSecurityFilterChain securityFilterChain = (DefaultSecurityFilterChain)http.build();
        this.authenticationContext.setLogoutHandlers(this.logoutConfigurer.getLogoutSuccessHandler(), this.logoutConfigurer.getLogoutHandlers());
        return securityFilterChain;
    }

    @Bean(name={"VaadinAuthenticationContext"})
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.exceptionHandling().accessDeniedHandler(this.createAccessDeniedHandler()).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), this.requestUtil::isEndpointRequest);
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = this.requestUtil::isFrameworkInternalRequest;
        http.csrf().ignoringRequestMatchers(requestMatcherArray);
        http.requestCache().requestCache((RequestCache)this.vaadinDefaultRequestCache);
        AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry urlRegistry = http.authorizeHttpRequests();
        RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
        requestMatcherArray2[0] = this.requestUtil::isFrameworkInternalRequest;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray2)).permitAll();
        RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
        requestMatcherArray3[0] = this.requestUtil::isAnonymousEndpoint;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray3)).permitAll();
        RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
        requestMatcherArray4[0] = this.requestUtil::isAnonymousRoute;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray4)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurity.getDefaultHttpSecurityPermitMatcher(this.requestUtil.getUrlMapping())})).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurity.getDefaultWebSecurityIgnoreMatcher(this.requestUtil.getUrlMapping())})).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        this.viewAccessChecker.enable();
    }

    @Bean(name={"VaadinWebSecurityCustomizerBean"})
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> {
            try {
                this.configure(web);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected void configure(WebSecurity web) throws Exception {
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher() {
        return VaadinWebSecurity.getDefaultHttpSecurityPermitMatcher("/*");
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        Stream.Builder paths = Stream.builder();
        Stream.of(HandlerHelper.getPublicResourcesRequiringSecurityContext()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).forEach(paths::add);
        return new OrRequestMatcher(paths.build().map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher() {
        return VaadinWebSecurity.getDefaultWebSecurityIgnoreMatcher("/*");
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        Stream<String> mappingRelativePaths = Stream.of(HandlerHelper.getPublicResources()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path));
        Stream<String> rootPaths = Stream.of(HandlerHelper.getPublicResourcesRoot());
        return new OrRequestMatcher(Stream.concat(mappingRelativePaths, rootPaths).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    protected void setLoginView(HttpSecurity http, String hillaLoginViewPath) throws Exception {
        this.setLoginView(http, hillaLoginViewPath, this.getDefaultLogoutUrl());
    }

    protected void setLoginView(HttpSecurity http, String hillaLoginViewPath, String logoutSuccessUrl) throws Exception {
        hillaLoginViewPath = this.applyUrlMapping(hillaLoginViewPath);
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage(hillaLoginViewPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        this.configureLogout(http, logoutSuccessUrl);
        http.exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(hillaLoginViewPath), AnyRequestMatcher.INSTANCE);
        this.viewAccessChecker.setLoginView(hillaLoginViewPath);
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView) throws Exception {
        this.setLoginView(http, flowLoginView, this.getDefaultLogoutUrl());
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView, String logoutSuccessUrl) throws Exception {
        Optional route = AnnotationReader.getAnnotationFor(flowLoginView, Route.class);
        if (!route.isPresent()) {
            throw new IllegalArgumentException("Unable find a @Route annotation on the login view " + flowLoginView.getName());
        }
        if (!(this.applicationContext instanceof WebApplicationContext)) {
            throw new RuntimeException("VaadinWebSecurity cannot be used without WebApplicationContext.");
        }
        VaadinServletContext vaadinServletContext = new VaadinServletContext(((WebApplicationContext)this.applicationContext).getServletContext());
        Object loginPath = RouteUtil.getRoutePath((VaadinContext)vaadinServletContext, flowLoginView);
        if (!((String)loginPath).startsWith("/")) {
            loginPath = "/" + (String)loginPath;
        }
        loginPath = this.applyUrlMapping((String)loginPath);
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage((String)loginPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        http.csrf().ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher((String)loginPath)});
        this.configureLogout(http, logoutSuccessUrl);
        http.exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint((String)loginPath), AnyRequestMatcher.INSTANCE);
        this.viewAccessChecker.setLoginView(flowLoginView);
    }

    protected void setOAuth2LoginPage(HttpSecurity http, String oauth2LoginPage) throws Exception {
        ((OAuth2LoginConfigurer)http.oauth2Login().loginPage(oauth2LoginPage).successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http))).permitAll();
        this.viewAccessChecker.setLoginView(this.servletContextPath + oauth2LoginPage);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer) throws Exception {
        this.setStatelessAuthentication(http, secretKey, issuer, 1800L);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer, long expiresIn) throws Exception {
        VaadinStatelessSecurityConfigurer vaadinStatelessSecurityConfigurer = new VaadinStatelessSecurityConfigurer();
        vaadinStatelessSecurityConfigurer.setSharedObjects(http);
        http.apply(vaadinStatelessSecurityConfigurer);
        SessionManagementConfigurer sessionManagementConfigurer = (SessionManagementConfigurer)http.getConfigurer(SessionManagementConfigurer.class);
        Field f = SessionManagementConfigurer.class.getDeclaredField("sessionManagementSecurityContextRepository");
        f.setAccessible(true);
        f.set(sessionManagementConfigurer, http.getSharedObject(SecurityContextRepository.class));
        vaadinStatelessSecurityConfigurer.withSecretKey().secretKey(secretKey).and().issuer(issuer).expiresIn(expiresIn);
    }

    protected String applyUrlMapping(String path) {
        return this.requestUtil.applyUrlMapping(path);
    }

    protected ViewAccessChecker getViewAccessChecker() {
        return this.viewAccessChecker;
    }

    protected void addLogoutHandlers(Consumer<LogoutHandler> registry) {
    }

    private void configureLogout(HttpSecurity http, String logoutSuccessUrl) throws Exception {
        SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        logoutSuccessHandler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        http.logout().logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler);
    }

    private String getDefaultLogoutUrl() {
        return this.servletContextPath.startsWith("/") ? this.servletContextPath : "/" + this.servletContextPath;
    }

    private VaadinSavedRequestAwareAuthenticationSuccessHandler getVaadinSavedRequestAwareAuthenticationSuccessHandler(HttpSecurity http) {
        VaadinSavedRequestAwareAuthenticationSuccessHandler vaadinSavedRequestAwareAuthenticationSuccessHandler = new VaadinSavedRequestAwareAuthenticationSuccessHandler();
        vaadinSavedRequestAwareAuthenticationSuccessHandler.setDefaultTargetUrl(this.applyUrlMapping(""));
        RequestCache requestCache = (RequestCache)http.getSharedObject(RequestCache.class);
        if (requestCache != null) {
            vaadinSavedRequestAwareAuthenticationSuccessHandler.setRequestCache(requestCache);
        }
        http.setSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class, (Object)vaadinSavedRequestAwareAuthenticationSuccessHandler);
        return vaadinSavedRequestAwareAuthenticationSuccessHandler;
    }

    private AccessDeniedHandler createAccessDeniedHandler() {
        AccessDeniedHandlerImpl defaultHandler = new AccessDeniedHandlerImpl();
        Http401UnauthorizedAccessDeniedHandler http401UnauthorizedHandler = new Http401UnauthorizedAccessDeniedHandler();
        LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler> exceptionHandlers = new LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler>();
        exceptionHandlers.put(CsrfException.class, http401UnauthorizedHandler);
        LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler> matcherHandlers = new LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler>();
        matcherHandlers.put(this.requestUtil::isEndpointRequest, new DelegatingAccessDeniedHandler(exceptionHandlers, (AccessDeniedHandler)new AccessDeniedHandlerImpl()));
        return new RequestMatcherDelegatingAccessDeniedHandler(matcherHandlers, (AccessDeniedHandler)defaultHandler);
    }

    private static class Http401UnauthorizedAccessDeniedHandler
    implements AccessDeniedHandler {
        private Http401UnauthorizedAccessDeniedHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
    }
}

