/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.spring.RootMappedCondition;
import com.vaadin.flow.spring.VaadinConfigurationProperties;
import java.io.Serializable;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class DevModeBrowserLauncher
implements SpringApplicationRunListener,
Serializable {
    public DevModeBrowserLauncher(SpringApplication application, String[] arguments) {
    }

    public void running(ConfigurableApplicationContext context) {
        try {
            VaadinConfigurationProperties properties = (VaadinConfigurationProperties)context.getBean(VaadinConfigurationProperties.class);
            if (properties.isLaunchBrowser()) {
                this.launchBrowserInDevelopmentMode((ApplicationContext)context);
            }
        }
        catch (Exception e) {
            DevModeBrowserLauncher.getLogger().debug("Failed to launch browser", (Throwable)e);
        }
    }

    private void launchBrowserInDevelopmentMode(ApplicationContext appContext) {
        if (!(appContext instanceof GenericWebApplicationContext)) {
            DevModeBrowserLauncher.getLogger().warn("Unable to determine production mode for an Spring Boot application context of type " + appContext.getClass().getName());
            return;
        }
        GenericWebApplicationContext webAppContext = (GenericWebApplicationContext)appContext;
        ServletContext servletContext = webAppContext.getServletContext();
        VaadinServletContext vaadinContext = new VaadinServletContext(servletContext);
        Lookup lookup = (Lookup)vaadinContext.getAttribute(Lookup.class);
        DevModeHandlerManager devModeHandlerManager = (DevModeHandlerManager)lookup.lookup(DevModeHandlerManager.class);
        if (devModeHandlerManager != null) {
            devModeHandlerManager.launchBrowserInDevelopmentMode(DevModeBrowserLauncher.getUrl(webAppContext));
        }
    }

    static String getUrl(GenericWebApplicationContext app) {
        String contextPath;
        String port = app.getEnvironment().getProperty("server.port");
        String host = "http://localhost:" + port;
        Object path = "/";
        String vaadinServletMapping = RootMappedCondition.getUrlMapping((Environment)app.getEnvironment());
        ServletContext servletContext = app.getServletContext();
        if (servletContext != null && (contextPath = servletContext.getContextPath()) != null && !contextPath.isEmpty()) {
            path = contextPath + "/";
        }
        if (vaadinServletMapping != null && !vaadinServletMapping.isEmpty()) {
            if (vaadinServletMapping.startsWith("/")) {
                vaadinServletMapping = vaadinServletMapping.substring(1);
            }
            if (vaadinServletMapping.endsWith("*")) {
                vaadinServletMapping = vaadinServletMapping.substring(0, vaadinServletMapping.length() - 1);
            }
            path = (String)path + vaadinServletMapping;
        }
        return host + (String)path;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeBrowserLauncher.class);
    }
}

