/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategy;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.stateless.VaadinStatelessSecurityConfigurer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.csrf.CsrfException;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class VaadinWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private VaadinDefaultRequestCache vaadinDefaultRequestCache;
    @Autowired
    private RequestUtil requestUtil;
    @Autowired
    private ViewAccessChecker viewAccessChecker;

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().requestMatchers(new RequestMatcher[]{VaadinWebSecurityConfigurerAdapter.getDefaultWebSecurityIgnoreMatcher(this.requestUtil.getUrlMapping())});
    }

    protected void configure(HttpSecurity http) throws Exception {
        SecurityContextHolder.setStrategyName((String)VaadinAwareSecurityContextHolderStrategy.class.getName());
        http.exceptionHandling().accessDeniedHandler(this.createAccessDeniedHandler()).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), this.requestUtil::isEndpointRequest);
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = this.requestUtil::isFrameworkInternalRequest;
        http.csrf().ignoringRequestMatchers(requestMatcherArray);
        http.requestCache().requestCache((RequestCache)this.vaadinDefaultRequestCache);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry = http.authorizeRequests();
        RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
        requestMatcherArray2[0] = this.requestUtil::isFrameworkInternalRequest;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray2)).permitAll();
        RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
        requestMatcherArray3[0] = this.requestUtil::isAnonymousEndpoint;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray3)).permitAll();
        RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
        requestMatcherArray4[0] = this.requestUtil::isAnonymousRoute;
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray4)).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurityConfigurerAdapter.getDefaultHttpSecurityPermitMatcher(this.requestUtil.getUrlMapping())})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        this.viewAccessChecker.enable();
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher() {
        return VaadinWebSecurityConfigurerAdapter.getDefaultHttpSecurityPermitMatcher("/*");
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        Stream.Builder<String> paths = Stream.builder();
        Stream.of(HandlerHelper.getPublicResourcesRequiringSecurityContext()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).forEach(paths::add);
        String mappedRoot = RequestUtil.applyUrlMapping(urlMapping, "");
        if ("/".equals(mappedRoot)) {
            paths.add("/vaadinServlet/**");
        } else {
            paths.add(mappedRoot);
            paths.add("/VAADIN/**");
        }
        return new OrRequestMatcher(paths.build().map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher() {
        return VaadinWebSecurityConfigurerAdapter.getDefaultWebSecurityIgnoreMatcher("/*");
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        return new OrRequestMatcher(Stream.of(HandlerHelper.getPublicResources()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    protected void setLoginView(HttpSecurity http, String fusionLoginViewPath) throws Exception {
        this.setLoginView(http, fusionLoginViewPath, "/");
    }

    protected void setLoginView(HttpSecurity http, String fusionLoginViewPath, String logoutUrl) throws Exception {
        fusionLoginViewPath = this.applyUrlMapping(fusionLoginViewPath);
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage(fusionLoginViewPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        http.logout().logoutSuccessUrl(logoutUrl);
        http.exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(fusionLoginViewPath), AnyRequestMatcher.INSTANCE);
        this.viewAccessChecker.setLoginView(fusionLoginViewPath);
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView) throws Exception {
        this.setLoginView(http, flowLoginView, "/");
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView, String logoutUrl) throws Exception {
        Optional route = AnnotationReader.getAnnotationFor(flowLoginView, Route.class);
        if (!route.isPresent()) {
            throw new IllegalArgumentException("Unable find a @Route annotation on the login view " + flowLoginView.getName());
        }
        Object loginPath = RouteUtil.getRoutePath(flowLoginView, (Route)((Route)route.get()));
        if (!((String)loginPath).startsWith("/")) {
            loginPath = "/" + (String)loginPath;
        }
        loginPath = this.applyUrlMapping((String)loginPath);
        FormLoginConfigurer formLogin = http.formLogin();
        formLogin.loginPage((String)loginPath).permitAll();
        formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        http.csrf().ignoringAntMatchers(new String[]{loginPath});
        http.logout().logoutSuccessUrl(logoutUrl);
        http.exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint((String)loginPath), AnyRequestMatcher.INSTANCE);
        this.viewAccessChecker.setLoginView(flowLoginView);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer) throws Exception {
        this.setStatelessAuthentication(http, secretKey, issuer, 1800L);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer, long expiresIn) throws Exception {
        VaadinStatelessSecurityConfigurer vaadinStatelessSecurityConfigurer = new VaadinStatelessSecurityConfigurer();
        http.apply(vaadinStatelessSecurityConfigurer);
        vaadinStatelessSecurityConfigurer.withSecretKey().secretKey(secretKey).and().issuer(issuer).expiresIn(expiresIn);
    }

    protected String applyUrlMapping(String path) {
        return this.requestUtil.applyUrlMapping(path);
    }

    private VaadinSavedRequestAwareAuthenticationSuccessHandler getVaadinSavedRequestAwareAuthenticationSuccessHandler(HttpSecurity http) {
        VaadinSavedRequestAwareAuthenticationSuccessHandler vaadinSavedRequestAwareAuthenticationSuccessHandler = new VaadinSavedRequestAwareAuthenticationSuccessHandler();
        vaadinSavedRequestAwareAuthenticationSuccessHandler.setDefaultTargetUrl(this.applyUrlMapping(""));
        RequestCache requestCache = (RequestCache)http.getSharedObject(RequestCache.class);
        if (requestCache != null) {
            vaadinSavedRequestAwareAuthenticationSuccessHandler.setRequestCache(requestCache);
        }
        return vaadinSavedRequestAwareAuthenticationSuccessHandler;
    }

    private AccessDeniedHandler createAccessDeniedHandler() {
        AccessDeniedHandlerImpl defaultHandler = new AccessDeniedHandlerImpl();
        Http401UnauthorizedAccessDeniedHandler http401UnauthorizedHandler = new Http401UnauthorizedAccessDeniedHandler();
        LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler> exceptionHandlers = new LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler>();
        exceptionHandlers.put(CsrfException.class, http401UnauthorizedHandler);
        LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler> matcherHandlers = new LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler>();
        matcherHandlers.put(this.requestUtil::isEndpointRequest, new DelegatingAccessDeniedHandler(exceptionHandlers, (AccessDeniedHandler)new AccessDeniedHandlerImpl()));
        return new RequestMatcherDelegatingAccessDeniedHandler(matcherHandlers, (AccessDeniedHandler)defaultHandler);
    }

    private static class Http401UnauthorizedAccessDeniedHandler
    implements AccessDeniedHandler {
        private Http401UnauthorizedAccessDeniedHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
    }
}

