/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.formula.LazyRefEval;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHyperlinkCellClickHandler
implements Spreadsheet.HyperlinkCellClickHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHyperlinkCellClickHandler.class);
    private final Spreadsheet spreadsheet;
    private HyperlinkOpenStyle openStyle;

    public DefaultHyperlinkCellClickHandler(Spreadsheet spreadsheet) {
        this(spreadsheet, HyperlinkOpenStyle.NewTab);
    }

    public DefaultHyperlinkCellClickHandler(Spreadsheet spreadsheet, HyperlinkOpenStyle openStyle) {
        this.spreadsheet = spreadsheet;
        this.openStyle = openStyle;
    }

    protected Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    protected HyperlinkOpenStyle getOpenStyle() {
        return this.openStyle;
    }

    public void setOpenStyle(HyperlinkOpenStyle openStyle) {
        this.openStyle = openStyle;
    }

    @Override
    public void onHyperLinkCellClick(Cell cell, Hyperlink hyperlink) {
        if (hyperlink != null && hyperlink.getAddress() != null) {
            if (hyperlink.getType() == HyperlinkType.DOCUMENT) {
                this.navigateTo(cell, hyperlink.getAddress());
            } else {
                this.openExternalLink(hyperlink.getAddress());
            }
        } else if (DefaultHyperlinkCellClickHandler.isHyperlinkFormulaCell(cell)) {
            String address = this.getHyperlinkFunctionTarget(cell);
            if (address.startsWith("#!")) {
                UI ui = UI.getCurrentOrThrow();
                ui.getPage().open(address.substring(2));
            } else if (address.startsWith("#")) {
                this.navigateTo(cell, address.substring(1));
            } else if (address.startsWith("[") && address.contains("]")) {
                this.navigateTo(cell, address.substring(address.indexOf("]") + 1));
            } else {
                this.openExternalLink(address);
            }
        }
    }

    private void navigateTo(Cell cell, String address) {
        if (address.contains("!")) {
            String currentSheetName = cell.getSheet().getSheetName();
            String sheetName = address.substring(0, address.indexOf("!"));
            String addressInSheet = address.substring(address.indexOf("!") + 1);
            if (!currentSheetName.equals(sheetName)) {
                int sheetPOIIndex = this.getSheetIndex(cell, sheetName);
                this.spreadsheet.setActiveSheetWithPOIIndex(sheetPOIIndex);
            }
            this.spreadsheet.initialSheetSelection = addressInSheet;
            this.spreadsheet.getCellSelectionManager().onSheetAddressChanged(addressInSheet, true);
        } else {
            this.spreadsheet.getCellSelectionManager().onSheetAddressChanged(address, false);
        }
    }

    private int getSheetIndex(Cell cell, String rawSheetName) {
        String sheetName = rawSheetName;
        if (sheetName.charAt(0) == '\'' && sheetName.charAt(sheetName.length() - 1) == '\'') {
            sheetName = sheetName.substring(1, sheetName.length() - 1);
        }
        return cell.getSheet().getWorkbook().getSheetIndex(sheetName);
    }

    @Override
    public String getHyperlinkFunctionTarget(Cell cell) {
        return this.getFirstArgumentFromFormula(cell);
    }

    protected String getFirstArgumentFromFormula(Cell cell) {
        String formula = cell.getCellFormula().replaceFirst("(?i)hyperlink\\s*\\(", "IF(true, ");
        try {
            ValueEval value = ((WorkbookEvaluatorProvider)this.spreadsheet.getFormulaEvaluator())._getWorkbookEvaluator().evaluate(formula, new CellReference(cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), false, false));
            if (value instanceof LazyRefEval) {
                LazyRefEval refEvalValue = (LazyRefEval)value;
                value = refEvalValue.getInnerValueEval(refEvalValue.getFirstSheetIndex());
            }
            if (value instanceof StringEval) {
                return ((StringEval)value).getStringValue();
            }
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return "";
        }
        return "";
    }

    public static final boolean isHyperlinkFormulaCell(Cell cell) {
        return cell != null && cell.getCellType() == CellType.FORMULA && cell.getCellFormula().startsWith("HYPERLINK(");
    }

    protected void openExternalLink(String address) {
        if (this.openStyle != null) {
            this.openStyle.openExternalLink(address);
        } else {
            HyperlinkOpenStyle.NewTab.openExternalLink(address);
        }
    }

    public static enum HyperlinkOpenStyle {
        NewTab{

            @Override
            public void openExternalLink(String address) {
                UI.getCurrentOrThrow().getPage().open(address, "_new");
            }
        }
        ,
        Replace{

            @Override
            public void openExternalLink(String address) {
                UI.getCurrentOrThrow().getPage().setLocation(address);
            }
        };


        public abstract void openExternalLink(String var1);
    }
}

