/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.spreadsheet.CellSelectionManager;
import com.vaadin.flow.component.spreadsheet.CellValueManager;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetUtil;
import com.vaadin.flow.component.spreadsheet.command.CellShiftValuesCommand;
import java.io.Serializable;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellSelectionShifter
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellSelectionShifter.class);
    private static final String rowShiftRegex = "[$]?[a-zA-Z]+[$]?\\d+";
    private static final Pattern rowShiftPattern = Pattern.compile("[$]?[a-zA-Z]+[$]?\\d+");
    private static final String stringSequenceRegex = "\\d+$";
    private static final Pattern stringSequencePattern = Pattern.compile("\\d+$");
    private final Spreadsheet spreadsheet;

    public CellSelectionShifter(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public void onSelectionIncreasePainted(int r1, int c1, int r2, int c2) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        if (paintedCellRange != null && this.spreadsheet.isRangeEditable(paintedCellRange) && this.spreadsheet.isRangeEditable(r1 - 1, c1 - 1, r2 - 1, c2 - 1)) {
            CellRangeAddress changedCellRangeAddress = null;
            CellShiftValuesCommand command = new CellShiftValuesCommand(this.spreadsheet, false);
            if (c1 != paintedCellRange.getFirstColumn() + 1) {
                changedCellRangeAddress = new CellRangeAddress(r1 - 1, r2 - 1, c1 - 1, paintedCellRange.getFirstColumn() - 1);
                command.captureCellRangeValues(changedCellRangeAddress);
                this.shiftColumnsLeftInSelection(c1);
                this.spreadsheet.updateMarkedCells();
            } else if (c2 != paintedCellRange.getLastColumn() + 1) {
                changedCellRangeAddress = new CellRangeAddress(r1 - 1, r2 - 1, paintedCellRange.getLastColumn() + 1, c2 - 1);
                command.captureCellRangeValues(changedCellRangeAddress);
                this.shiftColumnsRightInSelection(c2);
                this.spreadsheet.updateMarkedCells();
            } else if (r1 != paintedCellRange.getFirstRow() + 1) {
                changedCellRangeAddress = new CellRangeAddress(r1 - 1, paintedCellRange.getFirstRow() - 1, c1 - 1, c2 - 1);
                command.captureCellRangeValues(changedCellRangeAddress);
                this.shiftRowsUpInSelection(r1);
                this.spreadsheet.updateMarkedCells();
            } else if (r2 != paintedCellRange.getLastRow() + 1) {
                changedCellRangeAddress = new CellRangeAddress(paintedCellRange.getLastRow() + 1, r2 - 1, c1 - 1, c2 - 1);
                command.captureCellRangeValues(changedCellRangeAddress);
                this.shiftRowsDownInSelection(r2);
                this.spreadsheet.updateMarkedCells();
            }
            CellRangeAddress newPaintedCellRange = this.spreadsheet.createCorrectCellRangeAddress(r1, c1, r2, c2);
            this.getCellSelectionManager().handleCellRangeSelection(this.spreadsheet.getSelectedCellReference(), newPaintedCellRange, false);
            this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
            if (changedCellRangeAddress != null) {
                this.fireCellValueChangeEvent(changedCellRangeAddress);
            }
        }
    }

    private void fireCellValueChangeEvent(CellRangeAddress region) {
        HashSet<CellReference> cells = new HashSet<CellReference>();
        for (int x = region.getFirstColumn(); x <= region.getLastColumn(); ++x) {
            for (int y = region.getFirstRow(); y <= region.getLastRow(); ++y) {
                cells.add(new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), y, x, false, false));
            }
        }
        this.spreadsheet.fireEvent(new Spreadsheet.CellValueChangeEvent(this.spreadsheet, cells));
    }

    protected void shiftCellValue(Cell shiftedCell, Cell newCell, boolean removeShifted, Double sequenceIncrement) {
        if (newCell.getCellType() != CellType.BLANK || shiftedCell.getCellType() == CellType.BLANK) {
            newCell.setBlank();
        }
        this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(newCell, true);
        switch (shiftedCell.getCellType()) {
            case FORMULA: {
                this.shiftFormula(shiftedCell, newCell);
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(shiftedCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                newCell.setCellErrorValue(shiftedCell.getErrorCellValue());
                break;
            }
            case NUMERIC: {
                this.shiftNumeric(shiftedCell, newCell, sequenceIncrement);
                break;
            }
            case STRING: {
                this.shiftString(shiftedCell, newCell, sequenceIncrement);
                break;
            }
            case BLANK: {
                newCell.setBlank();
            }
        }
        this.spreadsheet.getCellValueManager().cellUpdated(newCell);
        if (removeShifted) {
            shiftedCell.setCellValue((String)null);
            this.spreadsheet.getCellValueManager().cellDeleted(shiftedCell);
        }
    }

    private void shiftString(Cell shiftedCell, Cell newCell, Double sequenceIncrement) {
        if (sequenceIncrement != null) {
            int dif = shiftedCell.getColumnIndex() != newCell.getColumnIndex() ? newCell.getColumnIndex() - shiftedCell.getColumnIndex() : newCell.getRowIndex() - shiftedCell.getRowIndex();
            Matcher matcher = stringSequencePattern.matcher(shiftedCell.getStringCellValue());
            if (matcher.find()) {
                String base = shiftedCell.getStringCellValue().substring(0, matcher.start());
                String currentValue = matcher.group();
                Double currVal = Double.parseDouble(currentValue);
                newCell.setCellValue(base + (int)Math.abs(currVal + sequenceIncrement * (double)dif));
            } else {
                newCell.setCellValue(shiftedCell.getStringCellValue());
            }
        } else {
            newCell.setCellValue(shiftedCell.getStringCellValue());
        }
    }

    private void shiftNumeric(Cell shiftedCell, Cell newCell, Double sequenceIncrement) {
        if (sequenceIncrement != null) {
            int dif = shiftedCell.getColumnIndex() != newCell.getColumnIndex() ? newCell.getColumnIndex() - shiftedCell.getColumnIndex() : newCell.getRowIndex() - shiftedCell.getRowIndex();
            newCell.setCellValue(shiftedCell.getNumericCellValue() + sequenceIncrement * (double)dif);
        } else {
            newCell.setCellValue(shiftedCell.getNumericCellValue());
        }
    }

    private void shiftFormula(Cell shiftedCell, Cell newCell) {
        try {
            if (shiftedCell.getColumnIndex() != newCell.getColumnIndex()) {
                int collDiff = newCell.getColumnIndex() - shiftedCell.getColumnIndex();
                Matcher matcher = rowShiftPattern.matcher(shiftedCell.getCellFormula());
                String originalFormula = shiftedCell.getCellFormula();
                StringBuilder newFormula = new StringBuilder();
                int lastEnd = 0;
                while (matcher.find()) {
                    String replacement;
                    String s = matcher.group();
                    if (!s.startsWith("$")) {
                        String oldIndexString = s.replaceAll("[$]{0,1}\\d+", "");
                        int columnIndex = SpreadsheetUtil.getColHeaderIndex(oldIndexString);
                        replacement = s.replace(oldIndexString, SpreadsheetUtil.getColHeader(columnIndex += collDiff));
                    } else {
                        replacement = s;
                    }
                    newFormula.append(originalFormula.substring(lastEnd, matcher.start()));
                    newFormula.append(replacement);
                    lastEnd = matcher.end();
                }
                newFormula.append(originalFormula.substring(lastEnd));
                newCell.setCellFormula(newFormula.toString());
            } else {
                int rowDiff = newCell.getRowIndex() - shiftedCell.getRowIndex();
                Matcher matcher = rowShiftPattern.matcher(shiftedCell.getCellFormula());
                String originalFormula = shiftedCell.getCellFormula();
                StringBuilder newFormula = new StringBuilder();
                int lastEnd = 0;
                while (matcher.find()) {
                    String replacement;
                    String s = matcher.group();
                    String rowString = s.replaceAll("[$]{0,1}[a-zA-Z]+", "");
                    if (!rowString.startsWith("$")) {
                        int row = Integer.parseInt(rowString);
                        replacement = s.replace(rowString, Integer.toString(row += rowDiff));
                    } else {
                        replacement = s;
                    }
                    newFormula.append(originalFormula.substring(lastEnd, matcher.start()));
                    newFormula.append(replacement);
                    lastEnd = matcher.end();
                }
                newFormula.append(originalFormula.substring(lastEnd));
                newCell.setCellFormula(newFormula.toString());
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            newCell.setCellFormula(shiftedCell.getCellFormula());
        }
        this.spreadsheet.getCellValueManager().getFormulaEvaluator().notifySetFormula(newCell);
    }

    public void onSelectionDecreasePainted(int r, int c) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        if (paintedCellRange != null && this.spreadsheet.isRangeEditable(paintedCellRange)) {
            CellReference selectedCellReference;
            CellShiftValuesCommand command = new CellShiftValuesCommand(this.spreadsheet, true);
            CellRangeAddress changedCellRangeAddress = new CellRangeAddress(r - 1, paintedCellRange.getLastRow(), c - 1, paintedCellRange.getLastColumn());
            command.captureCellRangeValues(changedCellRangeAddress);
            this.getCellValueManager().removeCells(r, c, paintedCellRange.getLastRow() + 1, paintedCellRange.getLastColumn() + 1, false);
            this.spreadsheet.updateMarkedCells();
            CellRangeAddress newPaintedCellRange = null;
            if (c != paintedCellRange.getFirstColumn() + 1) {
                newPaintedCellRange = this.spreadsheet.createCorrectCellRangeAddress(paintedCellRange.getFirstRow() + 1, paintedCellRange.getFirstColumn() + 1, paintedCellRange.getLastRow() + 1, c - 1);
            } else if (r != paintedCellRange.getFirstRow() + 1) {
                newPaintedCellRange = this.spreadsheet.createCorrectCellRangeAddress(paintedCellRange.getFirstRow() + 1, paintedCellRange.getFirstColumn() + 1, r - 1, paintedCellRange.getLastColumn() + 1);
            }
            if (newPaintedCellRange != null) {
                selectedCellReference = this.spreadsheet.getSelectedCellReference();
                if (!SpreadsheetUtil.isCellInRange(selectedCellReference, newPaintedCellRange)) {
                    selectedCellReference = new CellReference(this.spreadsheet.getActiveSheet().getSheetName(), newPaintedCellRange.getFirstRow(), newPaintedCellRange.getFirstColumn(), false, false);
                }
                this.getCellSelectionManager().handleCellRangeSelection(selectedCellReference, newPaintedCellRange, false);
            }
            if (c - 1 == (selectedCellReference = this.getCellSelectionManager().getSelectedCellReference()).getCol() && r - 1 == selectedCellReference.getRow()) {
                this.spreadsheet.loadCustomEditorOnSelectedCell();
            }
            this.spreadsheet.getSpreadsheetHistoryManager().addCommand(command);
            this.fireCellValueChangeEvent(changedCellRangeAddress);
        }
    }

    private void shiftRowsDownInSelection(int newLastRow) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        int r1 = paintedCellRange.getFirstRow() + 1;
        int r2 = paintedCellRange.getLastRow() + 1;
        int c1 = paintedCellRange.getFirstColumn() + 1;
        int c2 = paintedCellRange.getLastColumn() + 1;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        for (int shiftedRowIndex = r1; shiftedRowIndex <= r2; ++shiftedRowIndex) {
            Row shiftedRow = activeSheet.getRow(shiftedRowIndex - 1);
            for (int newRowIndex = r2 + 1 + (shiftedRowIndex - r1); newRowIndex <= newLastRow; newRowIndex += r2 - r1 + 1) {
                if (shiftedRow != null) {
                    Row newRow = activeSheet.getRow(newRowIndex - 1);
                    if (newRow == null) {
                        newRow = activeSheet.createRow(newRowIndex - 1);
                    }
                    for (int c = c1; c <= c2; ++c) {
                        Double sequenceIncrement = this.getColumnSequenceIncrement(c, r1, r2);
                        Cell shiftedCell = shiftedRow.getCell(c - 1);
                        Cell newCell = newRow.getCell(c - 1);
                        if (shiftedCell != null) {
                            if (newCell == null) {
                                newCell = newRow.createCell(c - 1);
                            }
                            this.shiftCellValue(shiftedCell, newCell, false, sequenceIncrement);
                            continue;
                        }
                        if (newCell == null) continue;
                        newCell.setCellStyle(null);
                        this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(newCell, true);
                        newCell.setCellValue((String)null);
                        this.getCellValueManager().cellDeleted(newCell);
                    }
                    continue;
                }
                this.getCellValueManager().removeCells(newRowIndex, c1, newRowIndex, c2, true);
            }
        }
    }

    private void shiftRowsUpInSelection(int newFirstRow) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        int r1 = paintedCellRange.getFirstRow() + 1;
        int r2 = paintedCellRange.getLastRow() + 1;
        int c1 = paintedCellRange.getFirstColumn() + 1;
        int c2 = paintedCellRange.getLastColumn() + 1;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        for (int shiftedRowIndex = r1; shiftedRowIndex <= r2; ++shiftedRowIndex) {
            Row shiftedRow = activeSheet.getRow(shiftedRowIndex - 1);
            int newRowIndex = r1 - 1 - (shiftedRowIndex - r1);
            while (newRowIndex >= newFirstRow) {
                if (shiftedRow != null) {
                    Row newRow = activeSheet.getRow(newRowIndex - 1);
                    if (newRow == null) {
                        newRow = activeSheet.createRow(newRowIndex - 1);
                    }
                    for (int c = c1; c <= c2; ++c) {
                        Double sequenceIncrement = this.getColumnSequenceIncrement(c, r1, r2);
                        Cell shiftedCell = shiftedRow.getCell(c - 1);
                        Cell newCell = newRow.getCell(c - 1);
                        if (shiftedCell != null) {
                            if (newCell == null) {
                                newCell = newRow.createCell(c - 1);
                            }
                            this.shiftCellValue(shiftedCell, newCell, false, sequenceIncrement);
                            continue;
                        }
                        if (newCell == null) continue;
                        newCell.setCellStyle(null);
                        this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(newCell, true);
                        newCell.setCellValue((String)null);
                        this.getCellValueManager().cellDeleted(newCell);
                    }
                } else {
                    this.getCellValueManager().removeCells(newRowIndex, c1, newRowIndex, c2, true);
                }
                newRowIndex = newRowIndex - (r2 - r1) - 1;
            }
        }
    }

    private void shiftColumnsRightInSelection(int newRightMostColumn) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        int r1 = paintedCellRange.getFirstRow() + 1;
        int r2 = paintedCellRange.getLastRow() + 1;
        int c1 = paintedCellRange.getFirstColumn() + 1;
        int c2 = paintedCellRange.getLastColumn() + 1;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        for (int rIndex = r1; rIndex <= r2; ++rIndex) {
            Row row = activeSheet.getRow(rIndex - 1);
            if (row == null) continue;
            Double sequenceIncrement = this.getRowSequenceIncrement(rIndex, c1, c2);
            for (int shiftedCellIndex = c1; shiftedCellIndex <= c2; ++shiftedCellIndex) {
                Cell shiftedCell = row.getCell(shiftedCellIndex - 1);
                for (int newCellIndex = c2 + 1 + (shiftedCellIndex - c1); newCellIndex <= newRightMostColumn; newCellIndex += c2 - c1 + 1) {
                    Cell newCell = row.getCell(newCellIndex - 1);
                    if (shiftedCell != null) {
                        if (newCell == null) {
                            newCell = row.createCell(newCellIndex - 1);
                        }
                        this.shiftCellValue(shiftedCell, newCell, false, sequenceIncrement);
                        continue;
                    }
                    if (newCell == null) continue;
                    newCell.setCellValue((String)null);
                    this.getCellValueManager().cellDeleted(newCell);
                    newCell.setCellStyle(null);
                    this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(newCell, true);
                }
            }
        }
    }

    private void shiftColumnsLeftInSelection(int newLeftMostColumn) {
        CellRangeAddress paintedCellRange = this.spreadsheet.getCellSelectionManager().getSelectedCellRange();
        int r1 = paintedCellRange.getFirstRow() + 1;
        int r2 = paintedCellRange.getLastRow() + 1;
        int c1 = paintedCellRange.getFirstColumn() + 1;
        int c2 = paintedCellRange.getLastColumn() + 1;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        for (int rIndex = r1; rIndex <= r2; ++rIndex) {
            Row row = activeSheet.getRow(rIndex - 1);
            if (row == null) continue;
            Double sequenceIncrement = this.getRowSequenceIncrement(rIndex, c1, c2);
            for (int shiftedCellIndex = c1; shiftedCellIndex <= c2; ++shiftedCellIndex) {
                Cell shiftedCell = row.getCell(shiftedCellIndex - 1);
                int newCellIndex = c1 - (shiftedCellIndex - c1) - 1;
                while (newCellIndex >= newLeftMostColumn) {
                    Cell newCell = row.getCell(newCellIndex - 1);
                    if (shiftedCell != null) {
                        if (newCell == null) {
                            newCell = row.createCell(newCellIndex - 1);
                        }
                        this.shiftCellValue(shiftedCell, newCell, false, sequenceIncrement);
                    } else if (newCell != null) {
                        newCell.setCellValue((String)null);
                        this.getCellValueManager().cellDeleted(newCell);
                        newCell.setCellStyle(null);
                        this.spreadsheet.getSpreadsheetStyleFactory().cellStyleUpdated(newCell, true);
                    }
                    newCellIndex = newCellIndex - (c2 - c1) - 1;
                }
            }
        }
    }

    private Double getRowSequenceIncrement(int rIndex, int c1, int c2) {
        Cell firstCell;
        Double result = null;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        Row row = activeSheet.getRow(rIndex - 1);
        if (row != null && (firstCell = row.getCell(c1 - 1)) != null) {
            if (firstCell.getCellType() == CellType.STRING) {
                return this.getSequenceIncrement(this.getRowStringValues(row, c1, c2));
            }
            if (firstCell.getCellType() == CellType.NUMERIC) {
                return this.getSequenceIncrement(this.getRowNumericValues(row, c1, c2));
            }
        }
        return result;
    }

    private String[] getColumnStringValues(Sheet activeSheet, int columnIndex, int r1, int r2) {
        Cell cell;
        Row row;
        String[] result = new String[r2 - r1 + 1];
        for (int i = r1; i <= r2 && (row = activeSheet.getRow(i - 1)) != null && (cell = row.getCell(columnIndex - 1)) != null && cell.getCellType() == CellType.STRING; ++i) {
            result[i - r1] = cell.getStringCellValue();
        }
        return result;
    }

    private Double[] getColumnNumericValues(Sheet activeSheet, int columnIndex, int r1, int r2) {
        Cell cell;
        Row row;
        Double[] result = new Double[r2 - r1 + 1];
        for (int i = r1; i <= r2 && (row = activeSheet.getRow(i - 1)) != null && (cell = row.getCell(columnIndex - 1)) != null && cell.getCellType() == CellType.NUMERIC; ++i) {
            result[i - r1] = cell.getNumericCellValue();
        }
        return result;
    }

    private String[] getRowStringValues(Row row, int c1, int c2) {
        Cell cell;
        String[] result = new String[c2 - c1 + 1];
        for (int i = c1; i <= c2 && (cell = row.getCell(i - 1)) != null && cell.getCellType() == CellType.STRING; ++i) {
            result[i - c1] = cell.getStringCellValue();
        }
        return result;
    }

    private Double[] getRowNumericValues(Row row, int c1, int c2) {
        Cell shiftedCell;
        Double[] result = new Double[c2 - c1 + 1];
        for (int i = c1; i <= c2 && (shiftedCell = row.getCell(i - 1)) != null && shiftedCell.getCellType() == CellType.NUMERIC; ++i) {
            result[i - c1] = shiftedCell.getNumericCellValue();
        }
        return result;
    }

    private Double getSequenceIncrement(Double[] values) {
        Double result = null;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] != null && values[i - 1] != null) {
                Double diff = values[i] - values[i - 1];
                if (result == null) {
                    result = diff;
                    continue;
                }
                if (result.equals(diff)) continue;
                return null;
            }
            return null;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Double getSequenceIncrement(String[] values) {
        Double result = null;
        String previousConstant = null;
        Double previousValue = null;
        Matcher matcher = stringSequencePattern.matcher(values[0]);
        if (!matcher.find()) return null;
        previousConstant = values[0].substring(0, matcher.start());
        previousValue = Double.parseDouble(matcher.group());
        if (values.length <= 1) return 1.0;
        for (int i = 1; i < values.length; ++i) {
            String currentValue = values[i];
            if (currentValue == null || !currentValue.startsWith(previousConstant)) return null;
            matcher = stringSequencePattern.matcher(currentValue);
            if (!matcher.find()) return null;
            String constant = currentValue.substring(0, matcher.start());
            if (!previousConstant.equals(constant)) return null;
            Double value = Double.parseDouble(matcher.group());
            Double diff = value - previousValue;
            if (result == null) {
                result = diff;
            } else if (!result.equals(diff)) {
                return null;
            }
            previousValue = value;
        }
        return result;
    }

    private Double getColumnSequenceIncrement(int cIndex, int r1, int r2) {
        Cell firstCell;
        Double result = null;
        Workbook workbook = this.spreadsheet.getWorkbook();
        Sheet activeSheet = workbook.getSheetAt(workbook.getActiveSheetIndex());
        Row row = activeSheet.getRow(r1 - 1);
        if (row != null && (firstCell = row.getCell(cIndex - 1)) != null) {
            if (firstCell.getCellType() == CellType.STRING) {
                return this.getSequenceIncrement(this.getColumnStringValues(activeSheet, cIndex, r1, r2));
            }
            if (firstCell.getCellType() == CellType.NUMERIC) {
                return this.getSequenceIncrement(this.getColumnNumericValues(activeSheet, cIndex, r1, r2));
            }
        }
        return result;
    }

    private CellValueManager getCellValueManager() {
        return this.spreadsheet.getCellValueManager();
    }

    private CellSelectionManager getCellSelectionManager() {
        return this.spreadsheet.getCellSelectionManager();
    }
}

