/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.client;

import com.vaadin.flow.component.spreadsheet.client.MergedRegion;
import java.io.Serializable;

public class MergedRegionUtil {
    public static MergedRegion findIncreasingSelection(MergedRegionContainer container, int topRow, int bottomRow, int leftColumn, int rightColumn) {
        MergedRegion region;
        if (topRow == bottomRow && leftColumn == rightColumn) {
            MergedRegion mergedRegion = container.getMergedRegion(leftColumn, topRow);
            if (mergedRegion == null) {
                mergedRegion = new MergedRegion();
                mergedRegion.col1 = leftColumn;
                mergedRegion.col2 = rightColumn;
                mergedRegion.row1 = topRow;
                mergedRegion.row2 = bottomRow;
            }
            return mergedRegion;
        }
        MergedRegion merged = container.getMergedRegionStartingFrom(leftColumn, topRow);
        if (merged != null && merged.col2 >= rightColumn && merged.row2 >= bottomRow) {
            return merged;
        }
        boolean trouble = false;
        int i = leftColumn;
        while (i <= rightColumn) {
            region = container.getMergedRegion(i, topRow);
            if (region != null) {
                i = region.col2 + 1;
                if (leftColumn > region.col1) {
                    leftColumn = region.col1;
                    trouble = true;
                }
                if (rightColumn < region.col2) {
                    rightColumn = region.col2;
                    trouble = true;
                }
                if (topRow <= region.row1) continue;
                topRow = region.row1;
                trouble = true;
                continue;
            }
            ++i;
        }
        if (topRow > bottomRow) {
            topRow = bottomRow;
        }
        i = topRow;
        while (i <= bottomRow) {
            region = container.getMergedRegion(rightColumn, i);
            if (region != null) {
                i = region.row2 + 1;
                if (rightColumn < region.col2) {
                    rightColumn = region.col2;
                    trouble = true;
                }
                if (topRow > region.row1) {
                    topRow = region.row1;
                    trouble = true;
                }
                if (bottomRow >= region.row2) continue;
                bottomRow = region.row2;
                trouble = true;
                continue;
            }
            ++i;
        }
        if (rightColumn < leftColumn) {
            rightColumn = leftColumn;
        }
        i = leftColumn;
        while (i <= rightColumn) {
            region = container.getMergedRegion(i, bottomRow);
            if (region != null) {
                i = region.col2 + 1;
                if (leftColumn > region.col1) {
                    leftColumn = region.col1;
                    trouble = true;
                }
                if (rightColumn < region.col2) {
                    rightColumn = region.col2;
                    trouble = true;
                }
                if (bottomRow >= region.row2) continue;
                bottomRow = region.row2;
                trouble = true;
                continue;
            }
            ++i;
        }
        if (bottomRow < topRow) {
            bottomRow = topRow;
        }
        i = topRow;
        while (i <= bottomRow) {
            region = container.getMergedRegion(leftColumn, i);
            if (region != null) {
                i = region.row2 + 1;
                if (leftColumn > region.col1) {
                    leftColumn = region.col1;
                    trouble = true;
                }
                if (topRow > region.row1) {
                    topRow = region.row1;
                    trouble = true;
                }
                if (bottomRow >= region.row2) continue;
                bottomRow = region.row2;
                trouble = true;
                continue;
            }
            ++i;
        }
        if (leftColumn > rightColumn) {
            leftColumn = rightColumn;
        }
        if (trouble) {
            return MergedRegionUtil.findIncreasingSelection(container, topRow, bottomRow, leftColumn, rightColumn);
        }
        if (topRow == bottomRow && leftColumn == rightColumn) {
            MergedRegion mergedRegion = container.getMergedRegion(leftColumn, topRow);
            if (mergedRegion == null) {
                mergedRegion = new MergedRegion();
                mergedRegion.col1 = leftColumn;
                mergedRegion.col2 = rightColumn;
                mergedRegion.row1 = topRow;
                mergedRegion.row2 = bottomRow;
            }
            return mergedRegion;
        }
        MergedRegion merged2 = container.getMergedRegionStartingFrom(leftColumn, topRow);
        if (merged2 != null && merged2.col2 >= rightColumn && merged2.row2 >= bottomRow) {
            return merged2;
        }
        MergedRegion result = new MergedRegion();
        result.col1 = leftColumn;
        result.col2 = rightColumn;
        result.row1 = topRow;
        result.row2 = bottomRow;
        return result;
    }

    public static interface MergedRegionContainer
    extends Serializable {
        public MergedRegion getMergedRegionStartingFrom(int var1, int var2);

        public MergedRegion getMergedRegion(int var1, int var2);
    }
}

