/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.chartdata;

import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ChartData {
    public String title;
    public List<AbstractSeriesData> plotData;
    public View3dData view3dData;
    public boolean blanksAsZeros;
    public BorderStyle borderStyle;
    public TitleProperties titleStyle;
    public LegendProperties legendProperties;
    public AxisProperties xAxisProperties;
    public List<AxisProperties> yAxesProperties;
    public BackgroundProperties background;

    public static class LegendProperties {
        public TextProperties textProperties;
        public LegendPosition position;
    }

    public static enum LegendPosition {
        NONE,
        BOTTOM,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        TOP;

    }

    public static class TitleProperties {
        public boolean isFloating;
        public TextProperties textProperties;
    }

    public static class TextProperties {
        public String fontFamily;
        public double size;
        public boolean bold;
        public boolean italics;
        public ColorProperties color;
    }

    public static class BorderStyle {
        public double width = 0.0;
        public int radius = 0;
        public ColorProperties color;
    }

    public static class View3dData {
        public int rotation3dAngleA = 30;
        public int rotation3dAngleB = 30;
    }

    public static class AxisProperties {
        public String title = "";
        public TextProperties textProperties;
        public Double minVal;
        public Double maxVal;
    }

    public static class ColorProperties {
        public int red;
        public int green;
        public int blue;
        public double opacity;

        public ColorProperties(int[] rgbUnsignedWithLum, double opacity) {
            this.opacity = opacity;
            this.red = rgbUnsignedWithLum[0];
            this.green = rgbUnsignedWithLum[1];
            this.blue = rgbUnsignedWithLum[2];
        }
    }

    public static class GradientProperties {
        public SortedMap<Double, ColorProperties> colorStops = new TreeMap<Double, ColorProperties>();
        public double angle;
    }

    public static class BackgroundProperties {
        public GradientProperties gradient;
        public ColorProperties color;
    }
}

