/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.charts.converter.Utils;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.AbstractSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.chartdata.ScatterSeriesData;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.AbstractSeriesReader;
import com.vaadin.flow.component.spreadsheet.charts.converter.xssfreader.LineSeriesReaderUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScatterSer;

public class ScatterSeriesReader
extends AbstractSeriesReader<CTScatterSer, ScatterSeriesData> {
    public ScatterSeriesReader(CTScatterChart ctChart, Spreadsheet spreadsheet, boolean showDataInHiddenCells) {
        super((XmlObject)ctChart, spreadsheet, showDataInHiddenCells);
    }

    @Override
    protected ScatterSeriesData createSeriesDataObject(CTScatterSer serie) {
        return new ScatterSeriesData();
    }

    @Override
    protected void fillSeriesData(ScatterSeriesData seriesData, CTScatterSer serie) {
        seriesData.name = this.tryGetSeriesName(serie.getTx());
        if (serie.getXVal() == null) {
            this.createSeriesDataPoints(serie.getYVal(), seriesData);
        } else {
            this.createSeriesDataPointsForScatter(serie.getXVal(), serie.getYVal(), seriesData);
        }
        if (serie.getMarker() != null) {
            LineSeriesReaderUtils.setMarkerForData(seriesData, serie.getMarker());
        }
        if (serie.getSpPr() != null) {
            LineSeriesReaderUtils.setDashStyleForData(seriesData, serie.getSpPr());
            LineSeriesReaderUtils.setLineWidthForData(seriesData, serie.getSpPr());
        }
    }

    protected void createSeriesDataPointsForScatter(CTAxDataSource xVal, CTNumDataSource yVal, ScatterSeriesData seriesData) {
        List<CellReference> ptListX = Utils.getAllReferencedCells(xVal.getNumRef().getF(), this.getSpreadsheet(), this.showDataInHiddenCells);
        final String formulaY = yVal.getNumRef().getF();
        List<CellReference> ptListY = Utils.getAllReferencedCells(formulaY, this.getSpreadsheet(), this.showDataInHiddenCells);
        ArrayList<AbstractSeriesData.SeriesPoint> list = new ArrayList<AbstractSeriesData.SeriesPoint>();
        for (int i = 0; i < ptListY.size(); ++i) {
            list.add(new AbstractSeriesData.SeriesPoint(this.getNumericValueFromCellRef(ptListX.get(i)), this.getNumericValueFromCellRef(ptListY.get(i))));
        }
        seriesData.seriesData = list;
        this.handleReferencedValueUpdates(ptListY, seriesData, AbstractSeriesReader.ValueUpdateMode.Y_VALUES);
        this.handleReferencedValueUpdates(ptListX, seriesData, AbstractSeriesReader.ValueUpdateMode.X_VALUES);
        seriesData.dataSelectListener = new AbstractSeriesData.DataSelectListener(){

            @Override
            public void dataSelected() {
                ScatterSeriesReader.this.getSpreadsheet().setSelection(formulaY);
            }
        };
    }
}

