/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.charts.converter;

import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    public static <T> T callMethodUsingReflection(Object o, String name) {
        try {
            Method method = o.getClass().getMethod(name, new Class[0]);
            return (T)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warning("Was not able to call method " + name + " using reflection");
            return null;
        }
    }

    public static <E extends Enum> E getEnumValueOrDefault(Class<? extends E> eClass, String value, E defaultValue) {
        try {
            return Enum.valueOf(eClass, value);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static String getStringValueFromFormula(String formula, Spreadsheet spreadsheet) {
        ArrayList<String> strings = new ArrayList<String>();
        for (CellReference ref : Utils.getAllReferencedCells(spreadsheet.getWorkbook().getSpreadsheetVersion(), formula)) {
            strings.add(Utils.getStringValue(ref, spreadsheet));
        }
        return Utils.join(strings, " ");
    }

    public static String join(List<String> array, String separator) {
        StringBuilder buf = new StringBuilder(array.size() * 16);
        for (String str : array) {
            buf.append(str);
            buf.append(separator);
        }
        buf.setLength(buf.length() - separator.length());
        return buf.toString();
    }

    public static List<CellReference> getAllReferencedCells(SpreadsheetVersion version, String formula) {
        ArrayList<CellReference> cellRefs = new ArrayList<CellReference>();
        for (AreaReference area : Utils.getAreaReferences(version, formula)) {
            cellRefs.addAll(Arrays.asList(area.getAllReferencedCells()));
        }
        return cellRefs;
    }

    public static AreaReference[] getAreaReferences(SpreadsheetVersion version, String formula) {
        String formulaIn = formula;
        if (formulaIn.startsWith("(") && formulaIn.endsWith(")")) {
            formulaIn = formulaIn.substring(1, formulaIn.length() - 1);
        }
        return AreaReference.generateContiguous((SpreadsheetVersion)version, (String)formulaIn);
    }

    public static List<CellReference> getAllReferencedVisibleCells(String formula, Spreadsheet spreadsheet) {
        return Utils.getAllReferencedCells(formula, spreadsheet, false);
    }

    public static List<CellReference> getAllReferencedCells(String formula, Spreadsheet spreadsheet, boolean includeHiddenCells) {
        List<CellReference> cellRefs = Utils.getAllReferencedCells(spreadsheet.getWorkbook().getSpreadsheetVersion(), formula);
        if (includeHiddenCells) {
            return cellRefs;
        }
        ArrayList<CellReference> visibleCells = new ArrayList<CellReference>();
        for (CellReference cr : cellRefs) {
            if (spreadsheet.isRowHidden(cr.getRow()) || spreadsheet.isColumnHidden(cr.getCol())) continue;
            visibleCells.add(cr);
        }
        return visibleCells;
    }

    public static String getStringValue(CellReference ref, Spreadsheet spreadsheet) {
        Sheet sheet = spreadsheet.getWorkbook().getSheet(ref.getSheetName());
        return spreadsheet.getCellValue(spreadsheet.getCell(ref, sheet));
    }

    public static Double getNumericValue(CellReference ref, Spreadsheet spreadsheet) {
        try {
            Sheet sheet = spreadsheet.getWorkbook().getSheet(ref.getSheetName());
            Cell cell = spreadsheet.getCell(ref, sheet);
            spreadsheet.getFormulaEvaluator().evaluateFormulaCell(cell);
            if (cell != null && (cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA)) {
                return cell.getNumericCellValue();
            }
        }
        catch (NullPointerException e) {
            LOGGER.warning("Could not parse number from cell on column " + ref.getCol() + " and row " + ref.getRow());
        }
        catch (IllegalStateException e) {
            LOGGER.warning("Could not parse number from cell on column " + ref.getCol() + " and row " + ref.getRow());
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Could not parse number from cell on column " + ref.getCol() + " and row " + ref.getRow());
        }
        catch (FormulaParseException e) {
            Utils.logError();
        }
        return null;
    }

    private static void logError() {
        String ERROR_TEXT = "The format of this data series is not supported by Vaadin Spreadsheet. Please see our list of known limitations: https://vaadin.com/docs/-/part/spreadsheet/spreadsheet-overview.html limitations.";
        LOGGER.warning("The format of this data series is not supported by Vaadin Spreadsheet. Please see our list of known limitations: https://vaadin.com/docs/-/part/spreadsheet/spreadsheet-overview.html limitations.");
    }
}

