/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet.framework;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectTools
implements Serializable {
    static final String CREATE_INSTANCE_FAILED = "Unable to create an instance of '%s'. Make sure it has a no-arg constructor";
    static final String CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS = "Unable to create an instance of '%s'. Make sure the class is static if it is a nested class.";
    static final String CREATE_INSTANCE_FAILED_ACCESS_EXCEPTION = "Unable to create an instance of '%s'. Make sure the class is public and that is has a public no-arg constructor.";
    static final String CREATE_INSTANCE_FAILED_NO_PUBLIC_NOARG_CONSTRUCTOR = "Unable to create an instance of '%s'. Make sure the class has a public no-arg constructor.";
    static final String CREATE_INSTANCE_FAILED_LOCAL_CLASS = "Cannot instantiate local class '%s'. Move class declaration outside the method.";
    static final String CREATE_INSTANCE_FAILED_CONSTRUCTOR_THREW_EXCEPTION = "Unable to create an instance of '%s'. The constructor threw an exception.";

    public static Method findMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) throws ExceptionInInitializerError {
        try {
            return cls.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static Object getJavaFieldValue(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), object.getClass());
            Method getter = pd.getReadMethod();
            if (getter != null) {
                return getter.invoke(object, (Object[])null);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(object);
    }

    public static Object getJavaFieldValue(Object object, Field field, Class<?> propertyType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter;
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), object.getClass());
            if (propertyType.isAssignableFrom(pd.getPropertyType()) && (getter = pd.getReadMethod()) != null) {
                return getter.invoke(object, (Object[])null);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!propertyType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException();
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(object);
    }

    public static void setJavaFieldValue(Object object, Field field, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), object.getClass());
            Method setter = pd.getWriteMethod();
            if (setter != null) {
                setter.invoke(object, value);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(object, value);
    }

    public static Class<?> convertPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                type = Boolean.class;
            } else if (type.equals(Integer.TYPE)) {
                type = Integer.class;
            } else if (type.equals(Float.TYPE)) {
                type = Float.class;
            } else if (type.equals(Double.TYPE)) {
                type = Double.class;
            } else if (type.equals(Byte.TYPE)) {
                type = Byte.class;
            } else if (type.equals(Character.TYPE)) {
                type = Character.class;
            } else if (type.equals(Short.TYPE)) {
                type = Short.class;
            } else if (type.equals(Long.TYPE)) {
                type = Long.class;
            }
        }
        return type;
    }

    private ReflectTools() {
    }

    public static Class<?> findCommonBaseType(Class<?> a, Class<?> b) {
        if (a.isInterface()) {
            throw new IllegalArgumentException("a cannot be an interface");
        }
        if (b.isInterface()) {
            throw new IllegalArgumentException("b cannot be an interface");
        }
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        Class<?> currentClass = a;
        while (!currentClass.isAssignableFrom(b)) {
            currentClass = currentClass.getSuperclass();
        }
        return currentClass;
    }

    public static <T> T createInstance(Class<T> cls) {
        ReflectTools.checkClassAccessibility(cls);
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_NO_PUBLIC_NOARG_CONSTRUCTOR, cls.getName()), e);
        }
        catch (InstantiationException e) {
            if (cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers())) {
                throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS, cls.getName()), e);
            }
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED, cls.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_ACCESS_EXCEPTION, cls.getName()), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED, cls.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_CONSTRUCTOR_THREW_EXCEPTION, cls.getName()), e);
        }
    }

    private static void checkClassAccessibility(Class<?> cls) {
        if (cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers())) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS, cls.getName()));
        }
        if (cls.isLocalClass()) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_LOCAL_CLASS, cls.getName()));
        }
    }

    public static Method getMethod(Class<?> listenerClass) {
        for (Method m : listenerClass.getDeclaredMethods()) {
            if (m.isSynthetic()) continue;
            return m;
        }
        throw new IllegalStateException("Class " + listenerClass.getName() + " does not have a method.");
    }
}

