/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.spreadsheet.PopupButton;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilter;
import com.vaadin.flow.component.spreadsheet.SpreadsheetFilterTable;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.poi.ss.util.CellRangeAddress;

public class ItemFilter
extends Div
implements SpreadsheetFilter {
    private static final String ITEM_FILTER_LAYOUT_CLASSNAME = "spreadsheet-item-filter-layout";
    private Spreadsheet spreadsheet;
    private CellRangeAddress filterRange;
    private Checkbox allItems;
    private CheckboxGroup<String> filterCheckbox;
    private ListDataProvider<String> filterOptionsProvider;
    private List<String> filterOptions = new ArrayList<String>();
    private ArrayList<String> allCellValues;
    private Collection<String> latestFilteredValues;
    private PopupButton popupButton;
    private boolean firstUpdate = true;
    private boolean cancelValueChangeUpdate;
    private SpreadsheetFilterTable filterTable;
    private Set<Integer> filteredRows;

    public ItemFilter(CellRangeAddress filterRange, Spreadsheet spreadsheet, PopupButton popupButton, SpreadsheetFilterTable filterTable) {
        this.filterRange = filterRange;
        this.spreadsheet = spreadsheet;
        this.popupButton = popupButton;
        this.filterTable = filterTable;
        this.allCellValues = new ArrayList();
        this.filteredRows = new HashSet<Integer>();
        this.latestFilteredValues = new LinkedHashSet<String>();
        this.initComponents();
        this.updateOptions();
    }

    protected void initComponents() {
        this.initAllItemsCheckbox();
        this.initOptions();
        this.initLayouts();
        this.initPopupButtonListeners();
    }

    protected void initLayouts() {
        this.add(new Component[]{this.allItems});
        this.add(new Component[]{this.filterCheckbox});
        this.setClassName(ITEM_FILTER_LAYOUT_CLASSNAME);
    }

    protected void initPopupButtonListeners() {
        this.popupButton.addPopupCloseListener(new PopupButton.PopupCloseListener(){

            @Override
            public void onPopupClose(PopupButton.PopupCloseEvent event) {
                if (!((Boolean)ItemFilter.this.allItems.getValue()).booleanValue()) {
                    Collection currentValue = (Collection)ItemFilter.this.filterCheckbox.getValue();
                    ItemFilter.this.cancelValueChangeUpdate = true;
                    if (currentValue.isEmpty()) {
                        if (ItemFilter.this.latestFilteredValues.isEmpty() || ItemFilter.this.latestFilteredValues.containsAll(ItemFilter.this.allCellValues)) {
                            ItemFilter.this.allItems.setValue((Object)true);
                            ItemFilter.this.filterCheckbox.setValue(new HashSet<String>(ItemFilter.this.allCellValues));
                        } else {
                            ItemFilter.this.filterCheckbox.setValue(new HashSet<String>(ItemFilter.this.latestFilteredValues));
                        }
                    } else if (currentValue.containsAll(ItemFilter.this.allCellValues)) {
                        ItemFilter.this.allItems.setValue((Object)true);
                    }
                    ItemFilter.this.cancelValueChangeUpdate = false;
                }
            }
        });
        this.popupButton.addPopupOpenListener(new PopupButton.PopupOpenListener(){

            @Override
            public void onPopupOpen(PopupButton.PopupOpenEvent event) {
                ItemFilter.this.updateOptions();
            }
        });
    }

    protected void initAllItemsCheckbox() {
        this.allItems = new Checkbox("(Select All)", true);
        this.allItems.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (!this.cancelValueChangeUpdate) {
                Boolean value = (Boolean)this.allItems.getValue();
                this.cancelValueChangeUpdate = true;
                if (value.booleanValue()) {
                    this.filterCheckbox.setValue(new HashSet<String>(this.allCellValues));
                    this.updateFilteredItems(this.allCellValues);
                } else {
                    this.filterCheckbox.setValue(Collections.emptySet());
                }
                this.cancelValueChangeUpdate = false;
            }
        });
    }

    protected void initOptions() {
        this.filterOptionsProvider = new ListDataProvider(this.filterOptions);
        this.filterCheckbox = new CheckboxGroup();
        this.filterCheckbox.setItems(this.filterOptionsProvider);
        this.filterCheckbox.addThemeVariants((ThemeVariant[])new CheckboxGroupVariant[]{CheckboxGroupVariant.LUMO_VERTICAL});
        this.filterCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            Collection value;
            if (this.firstUpdate) {
                this.firstUpdate = false;
            } else if (!this.cancelValueChangeUpdate && !(value = (Collection)this.filterCheckbox.getValue()).isEmpty()) {
                this.updateFilteredItems(value);
                this.cancelValueChangeUpdate = true;
                if (value.containsAll(this.allCellValues)) {
                    if (!((Boolean)this.allItems.getValue()).booleanValue()) {
                        this.allItems.setValue((Object)true);
                    }
                } else if (((Boolean)this.allItems.getValue()).booleanValue()) {
                    this.allItems.setValue((Object)false);
                }
                this.cancelValueChangeUpdate = false;
            }
        });
    }

    public void updateOptions() {
        Set<String> newValues = this.getAllValues();
        boolean needsSort = false;
        Iterator<String> iter = this.allCellValues.iterator();
        while (iter.hasNext()) {
            String old = iter.next();
            if (newValues.contains(old)) continue;
            this.filterOptions.remove(old);
            iter.remove();
        }
        for (String item : newValues) {
            if (this.allCellValues.contains(item)) continue;
            this.filterOptions.add(item);
            this.allCellValues.add(item);
            needsSort = true;
        }
        if (needsSort) {
            Comparator byString = (s1, s2) -> s1.compareToIgnoreCase((String)s2);
            Collections.sort(this.filterOptions, byString);
        }
        Set<String> visibleValues = this.getVisibleValues();
        this.cancelValueChangeUpdate = true;
        this.allItems.setValue((Object)visibleValues.containsAll(this.allCellValues));
        this.cancelValueChangeUpdate = false;
        this.filterOptionsProvider = new ListDataProvider(this.filterOptions);
        this.filterCheckbox.setItems(this.filterOptionsProvider);
        this.firstUpdate = true;
        this.filterCheckbox.setValue(visibleValues);
    }

    protected Set<String> getVisibleValues() {
        HashSet<String> values = new HashSet<String>();
        for (int r = this.filterRange.getFirstRow(); r <= this.filterRange.getLastRow(); ++r) {
            if (this.filteredRows.contains(r) || this.spreadsheet.isRowHidden(r)) continue;
            values.add(this.spreadsheet.getCellValue(this.spreadsheet.getCell(r, this.filterRange.getFirstColumn())));
        }
        return values;
    }

    protected Set<String> getAllValues() {
        HashSet<String> values = new HashSet<String>();
        for (int r = this.filterRange.getFirstRow(); r <= this.filterRange.getLastRow(); ++r) {
            values.add(this.spreadsheet.getCellValue(this.spreadsheet.getCell(r, this.filterRange.getFirstColumn())));
        }
        return values;
    }

    protected void updateFilteredItems(Collection<String> visibleValues) {
        this.filteredRows.clear();
        for (int r = this.filterRange.getFirstRow(); r <= this.filterRange.getLastRow(); ++r) {
            String cellValue = this.spreadsheet.getCellValue(this.spreadsheet.getCell(r, this.filterRange.getFirstColumn()));
            if (visibleValues.contains(cellValue)) continue;
            this.filteredRows.add(r);
        }
        this.latestFilteredValues = new ArrayList<String>(visibleValues);
        this.filterTable.onFiltersUpdated();
    }

    @Override
    public Set<Integer> getFilteredRows() {
        return this.filteredRows;
    }

    @Override
    public void clearFilter() {
        this.cancelValueChangeUpdate = true;
        this.allItems.setValue((Object)true);
        this.filterCheckbox.setValue(new HashSet<String>(this.allCellValues));
        this.filteredRows.clear();
        this.cancelValueChangeUpdate = false;
    }
}

