/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.spreadsheet;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.spreadsheet.Spreadsheet;
import com.vaadin.flow.component.spreadsheet.SpreadsheetHandlerImpl;
import elemental.json.JsonArray;
import elemental.json.JsonNumber;
import elemental.json.JsonValue;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetEventListener
implements ComponentEventListener<Spreadsheet.SpreadsheetEvent> {
    private final SpreadsheetHandlerImpl handler;
    Logger LOGGER = LoggerFactory.getLogger(SpreadsheetEventListener.class);

    public SpreadsheetEventListener(SpreadsheetHandlerImpl spreadsheetHandler) {
        this.handler = spreadsheetHandler;
    }

    private int toInt(JsonArray o, int pos) {
        return o == null ? 0 : (int)o.getNumber(pos);
    }

    private String toStr(JsonArray o, int pos) {
        return o == null ? null : o.getString(pos);
    }

    private boolean toBool(JsonArray o, int pos) {
        return o == null ? null : Boolean.valueOf(o.getBoolean(pos));
    }

    private double toNumber(JsonValue v) {
        return v instanceof JsonNumber ? ((JsonNumber)v).asNumber() : 0.0;
    }

    private HashMap<Integer, Float> toMapFloat(JsonArray o, int pos) {
        HashMap<Integer, Float> m = new HashMap<Integer, Float>();
        if (o == null) {
            return m;
        }
        JsonArray jso = o.getArray(pos);
        for (int i = 0; i < jso.length(); ++i) {
            m.put(i, Float.valueOf((float)this.toNumber(jso.get(i))));
        }
        return m;
    }

    private HashMap<Integer, Integer> toMapInt(JsonArray o, int pos) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        if (o == null) {
            return m;
        }
        JsonArray jso = o.getArray(pos);
        for (int i = 0; i < jso.length(); ++i) {
            m.put(i, (int)this.toNumber(jso.get(i)));
        }
        return m;
    }

    public void onComponentEvent(Spreadsheet.SpreadsheetEvent event) {
        String type = event.getType();
        JsonArray pars = (JsonArray)event.getData();
        this.LOGGER.debug(type + " " + (pars == null ? "null" : pars.toJson()));
        if ("onConnectorInit".equals(type)) {
            this.handler.onConnectorInit();
        } else if ("contextMenuOpenOnSelection".equals(type)) {
            this.handler.contextMenuOpenOnSelection(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("actionOnCurrentSelection".equals(type)) {
            this.handler.actionOnCurrentSelection(this.toStr(pars, 0));
        } else if ("rowHeaderContextMenuOpen".equals(type)) {
            this.handler.rowHeaderContextMenuOpen(this.toInt(pars, 0));
        } else if ("actionOnRowHeader".equals(type)) {
            this.handler.actionOnRowHeader(this.toStr(pars, 0));
        } else if ("columnHeaderContextMenuOpen".equals(type)) {
            this.handler.columnHeaderContextMenuOpen(this.toInt(pars, 0));
        } else if ("actionOnColumnHeader".equals(type)) {
            this.handler.actionOnColumnHeader(this.toStr(pars, 0));
        } else if ("onSheetScroll".equals(type)) {
            this.handler.onSheetScroll(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3));
        } else if ("sheetAddressChanged".equals(type)) {
            this.handler.sheetAddressChanged(this.toStr(pars, 0));
        } else if ("cellSelected".equals(type)) {
            this.handler.cellSelected(this.toInt(pars, 0), this.toInt(pars, 1), this.toBool(pars, 2));
        } else if ("cellRangeSelected".equals(type)) {
            this.handler.cellRangeSelected(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3));
        } else if ("cellAddedToSelectionAndSelected".equals(type)) {
            this.handler.cellAddedToSelectionAndSelected(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("cellsAddedToRangeSelection".equals(type)) {
            this.handler.cellsAddedToRangeSelection(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3));
        } else if ("rowSelected".equals(type)) {
            this.handler.rowSelected(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("rowAddedToRangeSelection".equals(type)) {
            this.handler.rowAddedToRangeSelection(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("columnSelected".equals(type)) {
            this.handler.columnSelected(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("columnAddedToSelection".equals(type)) {
            this.handler.columnAddedToSelection(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("selectionIncreasePainted".equals(type)) {
            this.handler.selectionIncreasePainted(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3));
        } else if ("selectionDecreasePainted".equals(type)) {
            this.handler.selectionDecreasePainted(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("cellValueEdited".equals(type)) {
            this.handler.cellValueEdited(this.toInt(pars, 0), this.toInt(pars, 1), this.toStr(pars, 2));
        } else if ("sheetSelected".equals(type)) {
            this.handler.sheetSelected(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2));
        } else if ("sheetRenamed".equals(type)) {
            this.handler.sheetRenamed(this.toInt(pars, 0), this.toStr(pars, 1));
        } else if ("sheetCreated".equals(type)) {
            this.handler.sheetCreated(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("cellRangePainted".equals(type)) {
            this.handler.cellRangePainted(this.toInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3), this.toInt(pars, 4), this.toInt(pars, 5));
        } else if ("deleteSelectedCells".equals(type)) {
            this.handler.deleteSelectedCells();
        } else if ("linkCellClicked".equals(type)) {
            this.handler.linkCellClicked(this.toInt(pars, 0), this.toInt(pars, 1));
        } else if ("rowsResized".equals(type)) {
            this.handler.rowsResized(this.toMapFloat(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3), this.toInt(pars, 4));
        } else if ("columnResized".equals(type)) {
            this.handler.columnResized(this.toMapInt(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2), this.toInt(pars, 3), this.toInt(pars, 4));
        } else if ("onRowAutofit".equals(type)) {
            this.handler.onRowAutofit(this.toInt(pars, 0));
        } else if ("onColumnAutofit".equals(type)) {
            this.handler.onColumnAutofit(this.toInt(pars, 0));
        } else if ("onUndo".equals(type)) {
            this.handler.onUndo();
        } else if ("onRedo".equals(type)) {
            this.handler.onRedo();
        } else if ("setCellStyleWidthRatios".equals(type)) {
            this.handler.setCellStyleWidthRatios(this.toMapFloat(pars, 0));
        } else if ("protectedCellWriteAttempted".equals(type)) {
            this.handler.protectedCellWriteAttempted();
        } else if ("onPaste".equals(type)) {
            this.handler.onPaste(this.toStr(pars, 0));
        } else if ("clearSelectedCellsOnCut".equals(type)) {
            this.handler.clearSelectedCellsOnCut();
        } else if ("updateCellComment".equals(type)) {
            this.handler.updateCellComment(this.toStr(pars, 0), this.toInt(pars, 1), this.toInt(pars, 2));
        } else if ("groupingCollapsed".equals(type)) {
            this.handler.setGroupingCollapsed(this.toBool(pars, 0), this.toInt(pars, 1), this.toBool(pars, 2));
        } else if ("levelHeaderClicked".equals(type)) {
            this.handler.levelHeaderClicked(this.toBool(pars, 0), this.toInt(pars, 1));
        }
    }
}

