/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.splitlayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.splitlayout.GeneratedVaadinSplitLayout;
import com.vaadin.flow.shared.Registration;
import java.util.Objects;
import java.util.Optional;

@NpmPackage(value="@vaadin/vaadin-split-layout", version="4.1.1")
public class SplitLayout
extends GeneratedVaadinSplitLayout<SplitLayout>
implements HasSize {
    private Component primaryComponent;
    private Component secondaryComponent;

    public SplitLayout() {
        this.setOrientation(Orientation.HORIZONTAL);
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent) {
        this();
        this.addToPrimary(primaryComponent);
        this.addToSecondary(secondaryComponent);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.setOrientation(orientation.toString().toLowerCase());
    }

    public Orientation getOrientation() {
        return Orientation.valueOf(super.getOrientationString().toUpperCase());
    }

    @Override
    public void addToPrimary(Component ... components) {
        if (components.length == 1) {
            this.primaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.primaryComponent = container;
        }
        this.setComponents();
    }

    public Component getPrimaryComponent() {
        return this.primaryComponent;
    }

    @Override
    public void addToSecondary(Component ... components) {
        if (components.length == 1) {
            this.secondaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.secondaryComponent = container;
        }
        this.setComponents();
    }

    public Component getSecondaryComponent() {
        return this.secondaryComponent;
    }

    public void setSplitterPosition(double position) {
        double primary = Math.min(Math.max(position, 0.0), 100.0);
        double secondary = 100.0 - primary;
        String styleName = this.getOrientation() == Orientation.VERTICAL ? "height" : "width";
        this.setPrimaryStyle(styleName, primary + "%");
        this.setSecondaryStyle(styleName, secondary + "%");
    }

    public void setPrimaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(this.primaryComponent, styleName, value);
    }

    public void setSecondaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(this.secondaryComponent, styleName, value);
    }

    private void setComponents() {
        this.removeAll();
        if (this.primaryComponent == null) {
            super.addToPrimary(new Component[]{new Div()});
        } else {
            super.addToPrimary(this.primaryComponent);
        }
        if (this.secondaryComponent == null) {
            super.addToSecondary(new Component[]{new Div()});
        } else {
            super.addToSecondary(this.secondaryComponent);
        }
    }

    @Override
    public void remove(Component ... components) {
        super.remove(components);
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    @Override
    public Registration addSplitterDragendListener(ComponentEventListener<GeneratedVaadinSplitLayout.SplitterDragendEvent<SplitLayout>> listener) {
        return super.addSplitterDragendListener(listener);
    }

    private void setInnerComponentStyle(Component innerComponent, String styleName, String value) {
        Optional.ofNullable(innerComponent).ifPresent(component -> component.getElement().getStyle().set(styleName, value));
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

