/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav.testbench;

import com.vaadin.flow.component.sidenav.testbench.SideNavItemElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-side-nav")
public class SideNavElement
extends TestBenchElement {
    public String getLabel() {
        return this.$("span").attributeContains("slot", "label").first().getText();
    }

    public boolean isCollapsible() {
        return this.hasAttribute("collapsible");
    }

    public void toggle() {
        WebElement element;
        try {
            element = this.getWrappedElement().getShadowRoot().findElement(By.cssSelector((String)"summary[part='label']"));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("Nav does not contain a toggle button", (Throwable)e);
        }
        this.executeScript("arguments[0].click();", new Object[]{element});
    }

    public List<SideNavItemElement> getItems() {
        return this.getItems(false);
    }

    public List<SideNavItemElement> getItems(boolean includeNestedItems) {
        return this.getItemsStream(includeNestedItems).collect(Collectors.toList());
    }

    public SideNavItemElement getSelectedItem() {
        return this.getItemsStream(true).filter(SideNavItemElement::isActive).findAny().orElse(null);
    }

    public SideNavItemElement getItemByLabel(String label) {
        return this.getItemsStream(true).filter(item -> label.equals(item.getLabel())).findAny().orElse(null);
    }

    public SideNavItemElement getItemByPath(String path) {
        return this.getItemsStream(true).filter(item -> path.equals(item.getPath())).findAny().orElse(null);
    }

    private Stream<SideNavItemElement> getItemsStream(boolean includeChildren) {
        String xpathExp = includeChildren ? ".//vaadin-side-nav-item" : "vaadin-side-nav-item";
        return SideNavElement.wrapElements((List)this.findElements(By.xpath((String)xpathExp)), (TestBenchCommandExecutor)this.getCommandExecutor()).stream().map(testBenchElement -> (SideNavItemElement)testBenchElement.wrap(SideNavItemElement.class));
    }
}

