/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.shared.ui.notification;

import com.vaadin.shared.Position;
import com.vaadin.shared.communication.SharedState;

/**
 * Shared state for {@link com.vaadin.ui.Notification}.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.2
 */
public class NotificationState extends SharedState {

    /**
     * The {@link com.vaadin.ui.Notification} caption, can be {@code null}.
     */
    public String caption;

    /**
     * The description, can be {@code null}.
     */
    public String description;

    /**
     * Whether texts are interpreted as HTML ({@code true}) or not
     * ({@code false}).
     */
    public boolean htmlContentAllowed;

    /**
     * The style name, can be {@code null}.
     */
    public String styleName;

    /**
     * The {@link Position} of the {@link com.vaadin.ui.Notification}, can not
     * be {@code null}.
     */
    public Position position = Position.MIDDLE_CENTER;

    /**
     * The delay in milliseconds before disappearing, {@code -1} for forever.
     */
    public int delay;
}
