/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

/**
 * Shared state for DetailsManager extension.
 *
 * @since 8.0
 */
public class DetailsManagerState extends AbstractGridExtensionState {

    /**
     * For informing the connector when details handling can be skipped
     * altogether as it's not possible to have any details rows without a
     * generator.
     * 
     * @since 8.9
     */
    public boolean hasDetailsGenerator = false;
}
