/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui;

import com.vaadin.shared.ui.abstractlisting.AbstractListingState;

/**
 * Shared state for {@code AbstractSingleSelect}.
 *
 * @author Vaadin Ltd.
 *
 * @since 8.0
 */
public class AbstractSingleSelectState extends AbstractListingState {

    /**
     * The key of the currently selected item or {@code null} if no item is
     * selected.
     */
    public String selectedItemKey;
}
