/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.osgi.resources;

import java.util.List;

/**
 * Used to declare multiple OsgiVaadinResources with a single OSGi component.
 * Each vaadin resource will be checked for the type (theme, widgetset,
 * resource) and registered to the OSGi context with the appropriate type.
 *
 * @since 8.6.0
 */
public interface OsgiVaadinContributor {
    List<OsgiVaadinResource> getContributions();
}
