/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

/**
 * The modes for height calculation that are supported by Grid ( client
 * ({@code com.vaadin.client.widgets.Grid}), server
 * ({@code com.vaadin.ui.Grid server}), and Escalator
 * ({@code com.vaadin.client.widgets.Escalator Escalator}).
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public enum HeightMode {
    /**
     * The height of the Component or Widget is defined by a CSS-like value.
     * (e.g. "100px", "50em" or "25%")
     */
    CSS,

    /**
     * The height of the Component or Widget in question is defined by a number
     * of rows.
     */
    ROW,

    /**
     * The height of the Component or Widget in question is defined by its
     * contents.
     */
    UNDEFINED;
}
