/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.grid;

import java.util.List;

import com.vaadin.shared.communication.ServerRpc;
import com.vaadin.shared.ui.dnd.DropEffect;

/**
 * RPC for firing server side drag start and drag end events when the
 * corresponding client side events happen on the drag source Grid.
 *
 * @author Vaadin Ltd.
 * @since 8.1
 */
public interface GridDragSourceRpc extends ServerRpc {

    /**
     * Called when dragstart event happens on client side.
     *
     * @param draggedItemKeys
     *            Keys of the items in Grid being dragged.
     */
    public void dragStart(List<String> draggedItemKeys);

    /**
     * Called when dragend event happens on client side.
     *
     * @param dropEffect
     *            Drop effect of the dragend event, extracted from {@code
     *         DataTransfer.dropEffect} parameter.
     * @param draggedItemKeys
     *            Keys of the items in Grid having been dragged.
     */
    public void dragEnd(DropEffect dropEffect, List<String> draggedItemKeys);
}
