/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui.combobox;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Client to server RPC interface for ComboBox.
 *
 * @since 8.0
 */
public interface ComboBoxServerRpc extends ServerRpc {
    /**
     * Create a new item in the combo box. This method can only be used when the
     * ComboBox is configured to allow the creation of new items by the user.
     *
     * @param itemValue
     *            user entered string value for the new item
     */
    public void createNewItem(String itemValue);

    /**
     * Sets the filter to use.
     *
     * @param filter
     *            filter string interpreted according to the current filtering
     *            mode
     */
    public void setFilter(String filter);

    /**
     * Reset the force update flag once the list contents have been updated.
     *
     * @since 8.9
     */
    public void resetForceDataSourceUpdate();
}
