/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.shared.ui;

import com.vaadin.shared.communication.ServerRpc;

/**
 * Delayed callback RPC interface.
 * <p>
 * Notifies the UI when a round-trip has been completed after a delayed callback
 * has been registered.
 *
 * @author Vaadin Ltd
 * @since 8.18
 */
public interface DelayedCallbackRpc extends ServerRpc {

    /**
     * Mark the round-trip completed for all the pending delayed callbacks up to
     * the given one.
     *
     * @param latestDelayedID
     *            the latest ID for a delayed callback.
     */
    public void received(long latestDelayedID);
}
