/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.declarative.converters;

import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.ui.declarative.DesignAttributeHandler;

/**
 * An converter for Object to/from String for {@link DesignAttributeHandler} to
 * use internally.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public class DesignObjectConverter implements Converter<String, Object> {

    @Override
    public Result<Object> convertToModel(String value, ValueContext context) {
        return Result.ok(value);
    }

    @Override
    public String convertToPresentation(Object value, ValueContext context) {
        if (value == null) {
            return null;
        }

        return value.toString();
    }

}
