/*
 * Copyright (C) 2000-2025 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.lang.reflect.Method;

import com.vaadin.event.ConnectorEventListener;
import com.vaadin.util.ReflectTools;

/**
 * Drop listener for HTML5 drop on a Grid row.
 *
 * @param <T>
 *            The Grid bean type.
 * @author Vaadin Ltd.
 * @see GridDragSource#addGridDragEndListener(GridDragEndListener)
 * @since 8.1
 */
@FunctionalInterface
public interface GridDragEndListener<T> extends ConnectorEventListener {

    static final Method DRAG_END_METHOD = ReflectTools
            .getMethod(GridDragEndListener.class);

    /**
     * Invoked when the user has dropped the dragged grid rows, or canceled the
     * drag.
     *
     * @param event
     *            The drag end event.
     */
    void dragEnd(GridDragEndEvent<T> event);
}
