/*
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.util.Collections;
import java.util.List;

import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.ui.Grid;
import com.vaadin.ui.dnd.event.DragEndEvent;

/**
 * Drop event on an HTML5 drop target {@link Grid} row.
 *
 * @param <T>
 *            The Grid bean type.
 * @author Vaadin Ltd.
 * @see GridDragSource#addGridDragStartListener(GridDragStartListener)
 * @since 8.1
 */
public class GridDragEndEvent<T> extends DragEndEvent<Grid<T>> {

    private final List<T> draggedItems;

    /**
     * Creates a drag end event.
     *
     * @param source
     *            Grid component in which the items were dragged.
     * @param dropEffect
     *            Drop effect from {@code DataTransfer.dropEffect} object.
     * @param draggedItems
     *            List of items having been dragged.
     */
    public GridDragEndEvent(Grid<T> source, DropEffect dropEffect,
            List<T> draggedItems) {
        super(source, dropEffect);

        this.draggedItems = draggedItems;
    }

    /**
     * Get the dragged row items.
     *
     * @return an unmodifiable set of items that were being dragged.
     */
    public List<T> getDraggedItems() {
        return Collections.unmodifiableList(draggedItems);
    }
}
