/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.select;

import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateNode;
import java.io.Serializable;

final class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static void disableClientValidation(Select component) {
        if (!component.getElement().getNode().isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation can only be disabled for a component when it has been attached to the UI and because it should be called again once the component is removed/added, you should call this method from the onAttach() method of the component.", ((Object)((Object)component)).toString()));
        }
        StateNode componentNode = component.getElement().getNode();
        componentNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(componentNode, (SerializableConsumer & Serializable)executionContext -> FieldValidationUtil.overrideClientValidation(component)));
    }

    private static void overrideClientValidation(Select component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return !this.invalid;};");
        if (component.isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Serializable[0]);
    }
}

