/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.function.ValueProvider;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberRenderer<SOURCE>
extends BasicRenderer<SOURCE, Number> {
    private Locale locale;
    private NumberFormat numberFormat;
    private String formatString;
    private String nullRepresentation;

    protected NumberRenderer(ValueProvider<SOURCE, Number> valueProvider) {
        this(valueProvider, Locale.getDefault());
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, NumberFormat numberFormat) {
        this(valueProvider, numberFormat, "");
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, NumberFormat numberFormat, String nullRepresentation) {
        super(valueProvider);
        if (numberFormat == null) {
            throw new IllegalArgumentException("Number format may not be null");
        }
        this.locale = null;
        this.numberFormat = numberFormat;
        this.formatString = null;
        this.nullRepresentation = nullRepresentation;
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, Locale locale) {
        this(valueProvider, NumberFormat.getInstance(locale));
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, String formatString, Locale locale) {
        this(valueProvider, formatString, locale, "");
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, String formatString) {
        this(valueProvider, formatString, Locale.getDefault(), "");
    }

    public NumberRenderer(ValueProvider<SOURCE, Number> valueProvider, String formatString, Locale locale, String nullRepresentation) {
        super(valueProvider);
        if (formatString == null) {
            throw new IllegalArgumentException("Format string may not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale may not be null");
        }
        this.locale = locale;
        this.numberFormat = null;
        this.formatString = formatString;
        this.nullRepresentation = nullRepresentation;
    }

    @Override
    protected String getFormattedValue(Number value) {
        String stringValue;
        if (value == null) {
            stringValue = this.nullRepresentation;
        } else if (this.formatString != null && this.locale != null) {
            stringValue = String.format(this.locale, this.formatString, value);
        } else if (this.numberFormat != null) {
            stringValue = this.numberFormat.format(value);
        } else {
            throw new IllegalStateException(String.format("Unable to format the given value: [locale: %s, numberFormat: %s, formatString: %s]", this.locale, this.numberFormat, this.formatString));
        }
        return stringValue;
    }
}

