/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.SerializableFunction;

public class IconRenderer<ITEM>
extends ComponentRenderer<Component, ITEM> {
    private final SerializableFunction<ITEM, ? extends Component> iconGenerator;
    private final ItemLabelGenerator<ITEM> itemLabelGenerator;

    public IconRenderer(SerializableFunction<ITEM, ? extends Component> iconGenerator) {
        this(iconGenerator, String::valueOf);
    }

    public IconRenderer(SerializableFunction<ITEM, ? extends Component> iconGenerator, ItemLabelGenerator<ITEM> itemLabelGenerator) {
        this.iconGenerator = iconGenerator;
        this.itemLabelGenerator = itemLabelGenerator;
    }

    @Override
    public Component createComponent(ITEM item) {
        Component icon = (Component)this.iconGenerator.apply(item);
        if (icon == null) {
            throw new IllegalStateException(String.format("Got 'null' as an icon for the item '%s'. Icon generator instance may not return 'null' values", item));
        }
        String text = this.itemLabelGenerator.apply(item);
        if (text == null) {
            throw new IllegalStateException(String.format("Got 'null' as a label value for the item '%s'. '%s' instance may not return 'null' values", item, ItemLabelGenerator.class.getSimpleName()));
        }
        IconComponent component = new IconComponent();
        component.add(new Component[]{icon});
        component.add(new Component[]{new IconComponent(text)});
        return component;
    }

    private static class IconComponent
    extends Component
    implements HasComponents {
        IconComponent() {
            super(ElementFactory.createDiv());
        }

        IconComponent(String text) {
            super(Element.createText((String)text));
        }
    }
}

