/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.orderedlayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import java.util.Objects;

@Tag(value="vaadin-scroller")
@NpmPackage(value="@vaadin/vaadin-ordered-layout", version="21.0.3")
@JsModule(value="@vaadin/vaadin-ordered-layout/vaadin-scroller.js")
public class Scroller
extends Component
implements HasSize,
HasStyle {
    private static final String SCROLL_DIRECTION_PROPERTY = "scrollDirection";
    private Component content;

    public Scroller() {
    }

    public Scroller(Component content) {
        this();
        this.setContent(content);
    }

    public Scroller(Component content, ScrollDirection scrollDirection) {
        this();
        this.setContent(content);
        this.setScrollDirection(scrollDirection);
    }

    public Scroller(ScrollDirection scrollDirection) {
        this();
        this.setScrollDirection(scrollDirection);
    }

    public void setContent(Component content) {
        if (this.content != null) {
            this.content.getElement().removeFromParent();
        }
        this.content = content;
        if (content != null) {
            this.getElement().appendChild(new Element[]{content.getElement()});
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setScrollDirection(ScrollDirection scrollDirection) {
        Objects.requireNonNull(scrollDirection, "Scroll direction must not be null");
        this.getElement().setProperty(SCROLL_DIRECTION_PROPERTY, scrollDirection.toWebComponentValue());
    }

    public ScrollDirection getScrollDirection() {
        return ScrollDirection.fromWebComponentValue(this.getElement().getProperty(SCROLL_DIRECTION_PROPERTY));
    }

    public static enum ScrollDirection {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;


        private String toWebComponentValue() {
            return BOTH == this ? null : this.name().toLowerCase();
        }

        private static ScrollDirection fromWebComponentValue(String stringValue) {
            return stringValue != null ? ScrollDirection.valueOf(stringValue.toUpperCase()) : BOTH;
        }
    }
}

