/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-notification")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.0.7"), @NpmPackage(value="@vaadin/notification", version="23.0.7"), @NpmPackage(value="@vaadin/vaadin-notification", version="23.0.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/notification/src/vaadin-notification.js"), @JsModule(value="@vaadin/polymer-legacy-adapter/template-renderer.js")})
public abstract class GeneratedVaadinNotification<R extends GeneratedVaadinNotification<R>>
extends Component {
    protected double getDurationDouble() {
        return this.getElement().getProperty("duration", 0.0);
    }

    protected void setDuration(double duration) {
        this.getElement().setProperty("duration", duration);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpenedBoolean() {
        return this.getElement().getProperty("opened", false);
    }

    protected void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    protected String getPositionString() {
        return this.getElement().getProperty("position");
    }

    protected void setPosition(String position) {
        this.getElement().setProperty("position", position == null ? "" : position);
    }

    protected void open() {
        this.getElement().callJsFunction("open", new Serializable[0]);
    }

    protected void close() {
        this.getElement().callJsFunction("close", new Serializable[0]);
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new OpenedChangeEvent<GeneratedVaadinNotification>(this, event.isUserOriginated())));
    }

    public static class OpenedChangeEvent<R extends GeneratedVaadinNotification<R>>
    extends ComponentEvent<R> {
        private final boolean opened;

        public OpenedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((GeneratedVaadinNotification)((Object)source)).isOpenedBoolean();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

