/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.messages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.util.List;
import java.util.Objects;

class JsonUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();

    JsonUtils() {
    }

    static JsonObject beanToJson(Object bean) {
        Objects.requireNonNull(bean);
        try {
            return Json.parse((String)objectMapper.writeValueAsString(bean));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error converting bean to JSON", e);
        }
    }

    static JsonArray listToJson(List<?> list) {
        Objects.requireNonNull(list);
        try {
            return (JsonArray)Json.instance().parse(objectMapper.writeValueAsString(list));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error converting list to JSON", e);
        }
    }
}

