/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.menubar.testbench;

import com.vaadin.flow.component.menubar.testbench.MenuBarItemElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

@Element(value="vaadin-menu-bar-submenu")
public class MenuBarSubMenuElement
extends TestBenchElement {
    public List<MenuBarItemElement> getMenuItems() {
        TestBenchElement overlayContent = this.findElement(By.cssSelector((String)":scope > [slot='overlay']"));
        return overlayContent.$(MenuBarItemElement.class).all();
    }

    public Optional<MenuBarItemElement> getMenuItem(String text) {
        return this.getMenuItems().stream().filter(item -> item.getText().equals(text)).findFirst();
    }

    public boolean isOpen() {
        try {
            return this.hasAttribute("opened");
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public void waitUntilClosed() {
        this.waitUntil(driver -> {
            try {
                return !this.hasAttribute("opened") && !this.hasAttribute("closing");
            }
            catch (StaleElementReferenceException e) {
                return true;
            }
        });
    }
}

