/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.layer;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.Assets;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.feature.PointBasedFeature;
import com.vaadin.flow.component.map.configuration.layer.VectorLayer;
import com.vaadin.flow.component.map.configuration.source.ClusterSource;
import com.vaadin.flow.component.map.configuration.source.VectorSource;
import com.vaadin.flow.component.map.configuration.style.Fill;
import com.vaadin.flow.component.map.configuration.style.Icon;
import com.vaadin.flow.component.map.configuration.style.Style;
import com.vaadin.flow.component.map.configuration.style.TextStyle;
import java.util.List;
import java.util.Objects;

public class FeatureLayer
extends VectorLayer {
    private boolean clusteringEnabled = false;
    private int clusterDistance = 50;
    private int clusterMinDistance = 50;
    private Style clusterStyle;

    public FeatureLayer() {
        this.setSource(new VectorSource());
        this.setClusterStyle(FeatureLayer.createDefaultClusterStyle());
    }

    @Override
    public String getType() {
        return "ol/layer/Feature";
    }

    @Override
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public VectorSource getSource() {
        return (VectorSource)super.getSource();
    }

    @JsonIgnore
    public List<Feature> getFeatures() {
        return this.getSource().getFeatures();
    }

    public void addFeature(Feature feature) {
        this.getSource().addFeature(feature);
    }

    public void removeFeature(Feature feature) {
        this.getSource().removeFeature(feature);
    }

    public void removeAllFeatures() {
        this.getSource().removeAllFeatures();
    }

    @JsonIgnore
    public boolean isClusteringEnabled() {
        return this.clusteringEnabled;
    }

    public void setClusteringEnabled(boolean clusteringEnabled) {
        if (this.clusteringEnabled != clusteringEnabled) {
            this.clusteringEnabled = clusteringEnabled;
            this.switchSourceType();
        }
    }

    @JsonIgnore
    public int getClusterDistance() {
        return this.clusterDistance;
    }

    public void setClusterDistance(int clusterDistance) {
        this.clusterDistance = clusterDistance;
        if (this.clusteringEnabled && this.getSource() instanceof ClusterSource) {
            ((ClusterSource)this.getSource()).setDistance(clusterDistance);
        }
    }

    @JsonIgnore
    public int getClusterMinDistance() {
        return this.clusterMinDistance;
    }

    public void setClusterMinDistance(int clusterMinDistance) {
        this.clusterMinDistance = clusterMinDistance;
        if (this.clusteringEnabled && this.getSource() instanceof ClusterSource) {
            ((ClusterSource)this.getSource()).setMinDistance(clusterMinDistance);
        }
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Style getClusterStyle() {
        return this.clusterStyle;
    }

    public void setClusterStyle(Style clusterStyle) {
        Objects.requireNonNull(clusterStyle);
        this.removeChild(this.clusterStyle);
        this.clusterStyle = clusterStyle;
        this.addChild(clusterStyle);
    }

    private void switchSourceType() {
        VectorSource newSource;
        VectorSource currentSource = this.getSource();
        List<Feature> currentFeatures = List.copyOf(currentSource.getFeatures());
        VectorSource.Options newOptions = this.createOptionsFromSource(currentSource);
        if (this.clusteringEnabled) {
            ClusterSource clusterSource = new ClusterSource(newOptions);
            clusterSource.setDistance(this.clusterDistance);
            clusterSource.setMinDistance(this.clusterMinDistance);
            newSource = clusterSource;
        } else {
            newSource = new VectorSource(newOptions);
        }
        this.setSource(newSource);
        for (Feature feature : currentFeatures) {
            if (this.clusteringEnabled && !(feature instanceof PointBasedFeature)) continue;
            newSource.addFeature(feature);
        }
    }

    private VectorSource.Options createOptionsFromSource(VectorSource source) {
        VectorSource.Options options = new VectorSource.Options();
        options.setAttributions((List)source.getAttributions());
        options.setAttributionsCollapsible(source.isAttributionsCollapsible());
        options.setProjection(source.getProjection());
        return options;
    }

    private static Style createDefaultClusterStyle() {
        Icon.Options iconOptions = new Icon.Options();
        iconOptions.setImg(Assets.CLUSTER.getHandler());
        iconOptions.setImgSize(new Icon.ImageSize(Assets.CLUSTER.getWidth(), Assets.CLUSTER.getHeight()));
        iconOptions.setScale(0.5);
        iconOptions.setAnchorOrigin(Icon.AnchorOrigin.TOP_LEFT);
        iconOptions.setAnchor(new Icon.Anchor(0.5, 0.5));
        Icon clusterIcon = new Icon(iconOptions);
        TextStyle textStyle = new TextStyle();
        textStyle.setFont("bold 12px sans-serif");
        textStyle.setFill(new Fill("#fff"));
        textStyle.setStroke(null);
        textStyle.setOffset(0, 0);
        Style style = new Style();
        style.setImage(clusterIcon);
        style.setTextStyle(textStyle);
        return style;
    }
}

