/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.configuration.AbstractConfigurationObject;
import com.vaadin.flow.component.map.configuration.View;
import com.vaadin.flow.component.map.configuration.layer.Layer;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class Configuration
extends AbstractConfigurationObject {
    private final List<Layer> layers = new ArrayList<Layer>();
    private View view;

    public Configuration() {
        this.setView(new View());
    }

    @Override
    public String getType() {
        return "ol/Map";
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public void addLayer(Layer layer) {
        Objects.requireNonNull(layer);
        this.layers.add(layer);
        this.addChild(layer);
    }

    public void prependLayer(Layer layer) {
        Objects.requireNonNull(layer);
        this.layers.add(0, layer);
        this.addChild(layer);
    }

    public void removeLayer(Layer layer) {
        Objects.requireNonNull(layer);
        this.layers.remove(layer);
        this.removeChild(layer);
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.removeChild(this.view);
        this.view = view;
        this.addChild(view);
    }

    @Override
    public void deepMarkAsDirty() {
        super.deepMarkAsDirty();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void collectChanges(Consumer<AbstractConfigurationObject> changeCollector) {
        super.collectChanges(changeCollector);
    }
}

