/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.configuration.style;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.vaadin.flow.component.map.configuration.AbstractConfigurationObject;
import com.vaadin.flow.component.map.configuration.style.Fill;
import com.vaadin.flow.component.map.configuration.style.Stroke;
import java.io.Serializable;

public class TextStyle
extends AbstractConfigurationObject {
    private String font = "13px sans-serif";
    private TextOffset offset = new TextOffset(0, 10);
    private double scale = 1.0;
    private double rotation = 0.0;
    private boolean rotateWithView = false;
    private TextAlign textAlign = TextAlign.CENTER;
    private TextBaseline textBaseline = TextBaseline.MIDDLE;
    private Fill fill;
    private Stroke stroke;
    private Fill backgroundFill;
    private Stroke backgroundStroke;
    private int padding = 0;

    public TextStyle() {
        this.setFill(new Fill("#333"));
        this.setStroke(new Stroke("#fff", 3.0));
    }

    @Override
    public String getType() {
        return "ol/style/Text";
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
        this.markAsDirty();
    }

    public TextOffset getOffset() {
        return this.offset;
    }

    public void setOffset(TextOffset offset) {
        this.offset = offset;
        this.markAsDirty();
    }

    public void setOffset(int x, int y) {
        this.setOffset(new TextOffset(x, y));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.markAsDirty();
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
        this.markAsDirty();
    }

    public boolean isRotateWithView() {
        return this.rotateWithView;
    }

    public void setRotateWithView(boolean rotateWithView) {
        this.rotateWithView = rotateWithView;
        this.markAsDirty();
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        this.markAsDirty();
    }

    public TextBaseline getTextBaseline() {
        return this.textBaseline;
    }

    public void setTextBaseline(TextBaseline textBaseline) {
        this.textBaseline = textBaseline;
        this.markAsDirty();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        this.removeChild(this.fill);
        this.fill = fill;
        this.addNullableChild(fill);
    }

    public void setFill(String fillColor) {
        this.setFill(new Fill(fillColor));
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.removeChild(this.stroke);
        this.stroke = stroke;
        this.addNullableChild(stroke);
    }

    public void setStroke(String strokeColor, int strokeWidth) {
        this.setStroke(new Stroke(strokeColor, strokeWidth));
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Fill getBackgroundFill() {
        return this.backgroundFill;
    }

    public void setBackgroundFill(Fill backgroundFill) {
        this.removeChild(this.backgroundFill);
        this.backgroundFill = backgroundFill;
        this.addNullableChild(backgroundFill);
    }

    public void setBackgroundFill(String fillColor) {
        this.setBackgroundFill(new Fill(fillColor));
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    public Stroke getBackgroundStroke() {
        return this.backgroundStroke;
    }

    public void setBackgroundStroke(Stroke backgroundStroke) {
        this.removeChild(this.backgroundStroke);
        this.backgroundStroke = backgroundStroke;
        this.addNullableChild(backgroundStroke);
    }

    public void setBackgroundStroke(String strokeColor, int strokeWidth) {
        this.setBackgroundStroke(new Stroke(strokeColor, strokeWidth));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.markAsDirty();
    }

    public static class TextOffset
    implements Serializable {
        private final int x;
        private final int y;

        public TextOffset(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static enum TextAlign {
        CENTER,
        LEFT,
        RIGHT,
        START,
        END;

    }

    public static enum TextBaseline {
        MIDDLE,
        TOP,
        BOTTOM,
        ALPHABETIC,
        HANGING,
        IDEOGRAPHIC;

    }
}

