/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.listbox.VaadinItem;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Tag(value="vaadin-list-box")
@HtmlImport(value="frontend://bower_components/vaadin-list-box/src/vaadin-list-box.html")
public class ListBox<T>
extends AbstractSinglePropertyField<ListBox<T>, T>
implements HasItemsAndComponents<T>,
SingleSelect<ListBox<T>, T>,
HasDataProvider<T>,
HasComponents {
    private DataProvider<T, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private ComponentRenderer<? extends Component, T> itemRenderer = new TextRenderer();
    private SerializablePredicate<T> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();

    public ListBox() {
        super("selected", null, Integer.class, ListBox::presentationToModel, ListBox::modelToPresentation);
    }

    private static <T> T presentationToModel(ListBox<T> listBox, Integer selectedIndex) {
        if (selectedIndex == null || selectedIndex == -1) {
            return null;
        }
        return super.getItemComponents().get(selectedIndex).getItem();
    }

    private static <T> Integer modelToPresentation(ListBox<T> listBox, T selectedItem) {
        if (selectedItem == null) {
            return -1;
        }
        List itemComponents = super.getItemComponents();
        int itemIndex = IntStream.range(0, itemComponents.size()).filter(i -> selectedItem.equals(((VaadinItem)((Object)((Object)itemComponents.get(i)))).getItem())).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find given value from the item set"));
        return itemIndex;
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.dataProvider = Objects.requireNonNull(dataProvider);
        dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.refresh(((DataChangeEvent.DataRefreshEvent)event).getItem());
            } else {
                this.rebuild();
            }
        });
        this.rebuild();
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public ComponentRenderer<? extends Component, T> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, T> itemRenderer) {
        this.itemRenderer = Objects.requireNonNull(itemRenderer);
        this.getItemComponents().forEach(this::refreshContent);
    }

    public void setItemEnabledProvider(SerializablePredicate<T> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    public SerializablePredicate<T> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        throw new UnsupportedOperationException("Not supported by the client-side web-component: https://github.com/vaadin/vaadin-list-box/issues/19");
    }

    private void rebuild() {
        this.removeAll();
        this.setValue(null);
        this.getDataProvider().fetch(new Query()).map(this::createItemComponent).forEach(xva$0 -> this.add(new Component[]{xva$0}));
    }

    private VaadinItem<T> createItemComponent(T item) {
        VaadinItem<T> itemComponent = new VaadinItem<T>(item);
        this.refresh(itemComponent);
        return itemComponent;
    }

    private void refresh(T item) {
        VaadinItem itemComponent = this.getItemComponents().stream().filter(component -> component.getItem().equals(item)).findFirst().get();
        this.refresh(itemComponent);
    }

    private void refresh(VaadinItem<T> itemComponent) {
        this.refreshContent(itemComponent);
        this.refreshEnabled(itemComponent);
    }

    private void refreshContent(VaadinItem<T> itemComponent) {
        itemComponent.removeAll();
        itemComponent.add(new Component[]{this.itemRenderer.createComponent(itemComponent.getItem())});
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    private void refreshEnabled(VaadinItem<T> itemComponent) {
        itemComponent.setEnabled(this.itemEnabledProvider.test(itemComponent.getItem()));
    }

    private List<VaadinItem<T>> getItemComponents() {
        return this.getChildren().filter(VaadinItem.class::isInstance).map(component -> (VaadinItem)((Object)component)).collect(Collectors.toList());
    }
}

