/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro.testbench;

import com.vaadin.flow.component.gridpro.testbench.GridProColumnElement;
import com.vaadin.flow.component.gridpro.testbench.GridTHTDElement;
import com.vaadin.flow.component.gridpro.testbench.GridTRElement;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-grid-pro")
public class GridProElement
extends TestBenchElement {
    public void scrollToRow(int row) {
        this.callFunction("scrollToIndex", new Object[]{row});
    }

    public int getFirstVisibleRowIndex() {
        Object index = this.executeScript("return arguments[0]._firstVisibleIndex", new Object[]{this});
        if (index != null) {
            return ((Long)index).intValue();
        }
        return -1;
    }

    public GridTHTDElement getCell(int rowIndex, int colIndex) {
        GridProColumnElement column = this.getVisibleColumns().get(colIndex);
        return this.getCell(rowIndex, column);
    }

    public GridTHTDElement getCell(int rowIndex, GridProColumnElement column) {
        if (!this.isRowInView(rowIndex)) {
            this.scrollToRow(rowIndex);
        }
        GridTRElement row = this.getRow(rowIndex);
        return row.getCell(column);
    }

    public int getLastVisibleRowIndex() {
        Object index = this.executeScript("return arguments[0]._lastVisibleIndex", new Object[]{this});
        if (index != null) {
            return ((Long)index).intValue();
        }
        return -1;
    }

    public GridTHTDElement getHeaderCell(int columnIndex) {
        return this.getVisibleColumns().get(columnIndex).getHeaderCell();
    }

    public TestBenchElement getHeaderCellContent(int rowIndex, int columnIndex) {
        TestBenchElement thead = this.$("thead").id("header");
        List headerRows = thead.findElements(By.tagName((String)"tr"));
        List headerCells = ((WebElement)headerRows.get(rowIndex)).findElements(By.tagName((String)"th"));
        String slotName = ((WebElement)headerCells.get(columnIndex)).findElement(By.tagName((String)"slot")).getAttribute("name");
        return this.findElement(By.cssSelector((String)("vaadin-grid-cell-content[slot='" + slotName + "']")));
    }

    private boolean isRowInView(int rowIndex) {
        return this.getFirstVisibleRowIndex() <= rowIndex && rowIndex <= this.getLastVisibleRowIndex();
    }

    public GridTRElement getRow(int rowIndex) {
        String script = "var grid = arguments[0];var rowIndex = arguments[1];var rowsInDom = grid.$.items.children;var rowInDom = Array.from(rowsInDom).filter(function(row) { return !row.hidden && row.index == rowIndex;})[0];return rowInDom;";
        return (GridTRElement)((TestBenchElement)this.executeScript(script, new Object[]{this, rowIndex})).wrap(GridTRElement.class);
    }

    protected void generatedColumnIdsIfNeeded() {
        String generateIds = "const grid = arguments[0];if (!grid.__generatedTbId) {  grid.__generatedTbId = 1;}grid._getColumns().forEach(function(column) {  if (!column.__generatedTbId) {    column.__generatedTbId = grid.__generatedTbId++;  }});";
        this.executeScript(generateIds, new Object[]{this});
    }

    public List<GridProColumnElement> getVisibleColumns() {
        this.generatedColumnIdsIfNeeded();
        String getVisibleColumnsJS = "return arguments[0]._getColumns().filter(function(column) {return !column.hidden;}).sort(function(a,b) { return a._order - b._order;}).map(function(column) { return column.__generatedTbId;});";
        List elements = (List)this.executeScript(getVisibleColumnsJS, new Object[]{this});
        return elements.stream().map(id -> new GridProColumnElement((Long)id, this)).collect(Collectors.toList());
    }
}

